/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.NodeSubregistry;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;

abstract class AbstractResourceRegistration
implements ManagementResourceRegistration {
    private final String valueString;
    private final NodeSubregistry parent;
    private RootInvocation rootInvocation;

    AbstractResourceRegistration(String valueString, NodeSubregistry parent) {
        this.valueString = valueString;
        this.parent = parent;
    }

    NodeSubregistry getParent() {
        return this.parent;
    }

    @Override
    public final ManagementResourceRegistration registerSubModel(PathElement address, DescriptionProvider descriptionProvider) {
        return this.registerSubModel(new SimpleResourceDefinition(address, descriptionProvider));
    }

    @Override
    public abstract ManagementResourceRegistration registerSubModel(ResourceDefinition var1);

    @Override
    public boolean isAllowsOverride() {
        return !this.isRemote() && this.parent != null && "*".equals(this.valueString);
    }

    @Override
    public ManagementResourceRegistration registerOverrideModel(String name, OverrideDescriptionProvider descriptionProvider) {
        if (name == null) {
            throw ControllerMessages.MESSAGES.nullVar("name");
        }
        if (descriptionProvider == null) {
            throw ControllerMessages.MESSAGES.nullVar("descriptionProvider");
        }
        if (this.parent == null) {
            throw ControllerMessages.MESSAGES.cannotOverrideRootRegistration();
        }
        if (!"*".equals(this.valueString)) {
            throw ControllerMessages.MESSAGES.cannotOverrideNonWildCardRegistration(this.valueString);
        }
        PathElement pe = PathElement.pathElement(this.parent.getKeyName(), name);
        return this.parent.getParent().registerSubModel(pe, new OverrideDescriptionCombiner(this.getModelDescription(PathAddress.EMPTY_ADDRESS), descriptionProvider));
    }

    @Override
    public void unregisterOverrideModel(String name) {
        if (name == null) {
            throw ControllerMessages.MESSAGES.nullVar("name");
        }
        if ("*".equals(name)) {
            throw ControllerMessages.MESSAGES.wildcardRegistrationIsNotAnOverride();
        }
        if (this.parent == null) {
            throw ControllerMessages.MESSAGES.rootRegistrationIsNotOverridable();
        }
        PathElement pe = PathElement.pathElement(this.parent.getKeyName(), name);
        this.parent.getParent().unregisterSubModel(pe);
    }

    @Override
    public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider) {
        this.registerOperationHandler(operationName, handler, descriptionProvider, false);
    }

    @Override
    public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, EnumSet<OperationEntry.Flag> flags) {
        this.registerOperationHandler(operationName, handler, descriptionProvider, false, OperationEntry.EntryType.PUBLIC, flags);
    }

    @Override
    public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited) {
        this.registerOperationHandler(operationName, handler, descriptionProvider, inherited, OperationEntry.EntryType.PUBLIC);
    }

    @Override
    public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, EnumSet<OperationEntry.Flag> flags) {
        this.registerOperationHandler(operationName, handler, descriptionProvider, inherited, OperationEntry.EntryType.PUBLIC, flags);
    }

    @Override
    public void registerOperationHandler(OperationDefinition definition, OperationStepHandler handler) {
        this.registerOperationHandler(definition, handler, false);
    }

    @Override
    public abstract void registerOperationHandler(OperationDefinition var1, OperationStepHandler var2, boolean var3);

    @Override
    public abstract void registerOperationHandler(String var1, OperationStepHandler var2, DescriptionProvider var3, boolean var4, OperationEntry.EntryType var5);

    @Override
    public abstract void registerOperationHandler(String var1, OperationStepHandler var2, DescriptionProvider var3, boolean var4, OperationEntry.EntryType var5, EnumSet<OperationEntry.Flag> var6);

    @Override
    public abstract void unregisterOperationHandler(String var1);

    @Override
    public abstract void registerProxyController(PathElement var1, ProxyController var2) throws IllegalArgumentException;

    @Override
    public abstract void unregisterProxyController(PathElement var1);

    @Override
    public final OperationEntry getOperationEntry(PathAddress pathAddress, String operationName) {
        if (this.parent != null) {
            RootInvocation ri = this.getRootInvocation();
            return ri.root.getOperationEntry(ri.pathAddress.append(pathAddress), operationName);
        }
        OperationEntry inheritable = this.getInheritableOperationEntry(operationName);
        OperationEntry result = this.getOperationEntry((ListIterator<PathElement>)pathAddress.iterator(), operationName, inheritable);
        NodeSubregistry ancestorSubregistry = this.parent;
        while (result == null && ancestorSubregistry != null) {
            AbstractResourceRegistration ancestor = ancestorSubregistry.getParent();
            result = ancestor.getInheritableOperationEntry(operationName);
            ancestorSubregistry = ancestor.parent;
        }
        return result;
    }

    abstract OperationEntry getOperationEntry(ListIterator<PathElement> var1, String var2, OperationEntry var3);

    abstract OperationEntry getInheritableOperationEntry(String var1);

    @Override
    public final OperationStepHandler getOperationHandler(PathAddress pathAddress, String operationName) {
        OperationEntry entry = this.getOperationEntry(pathAddress, operationName);
        return entry == null ? null : entry.getOperationHandler();
    }

    @Override
    public final DescriptionProvider getOperationDescription(PathAddress address, String operationName) {
        OperationEntry entry = this.getOperationEntry(address, operationName);
        return entry == null ? null : entry.getDescriptionProvider();
    }

    @Override
    public final Set<OperationEntry.Flag> getOperationFlags(PathAddress pathAddress, String operationName) {
        OperationEntry entry = this.getOperationEntry(pathAddress, operationName);
        return entry == null ? null : entry.getFlags();
    }

    @Override
    public final AttributeAccess getAttributeAccess(PathAddress address, String attributeName) {
        if (this.parent != null) {
            RootInvocation ri = this.getRootInvocation();
            return ri.root.getAttributeAccess(ri.pathAddress.append(address), attributeName);
        }
        return this.getAttributeAccess((ListIterator<PathElement>)address.iterator(), attributeName);
    }

    abstract AttributeAccess getAttributeAccess(ListIterator<PathElement> var1, String var2);

    @Override
    public final Map<String, OperationEntry> getOperationDescriptions(PathAddress address, boolean inherited) {
        if (this.parent != null) {
            RootInvocation ri = this.getRootInvocation();
            return ri.root.getOperationDescriptions(ri.pathAddress.append(address), inherited);
        }
        TreeMap<String, OperationEntry> providers = new TreeMap<String, OperationEntry>();
        this.getOperationDescriptions((ListIterator<PathElement>)address.iterator(), providers, inherited);
        return providers;
    }

    abstract void getOperationDescriptions(ListIterator<PathElement> var1, Map<String, OperationEntry> var2, boolean var3);

    @Override
    public final DescriptionProvider getModelDescription(PathAddress address) {
        if (this.parent != null) {
            RootInvocation ri = this.getRootInvocation();
            return ri.root.getModelDescription(ri.pathAddress.append(address));
        }
        return this.getModelDescription((ListIterator<PathElement>)address.iterator());
    }

    abstract DescriptionProvider getModelDescription(ListIterator<PathElement> var1);

    @Override
    public final Set<String> getAttributeNames(PathAddress address) {
        if (this.parent != null) {
            RootInvocation ri = this.getRootInvocation();
            return ri.root.getAttributeNames(ri.pathAddress.append(address));
        }
        return this.getAttributeNames((ListIterator<PathElement>)address.iterator());
    }

    abstract Set<String> getAttributeNames(ListIterator<PathElement> var1);

    @Override
    public final Set<String> getChildNames(PathAddress address) {
        if (this.parent != null) {
            RootInvocation ri = this.getRootInvocation();
            return ri.root.getChildNames(ri.pathAddress.append(address));
        }
        return this.getChildNames((ListIterator<PathElement>)address.iterator());
    }

    abstract Set<String> getChildNames(ListIterator<PathElement> var1);

    @Override
    public final Set<PathElement> getChildAddresses(PathAddress address) {
        if (this.parent != null) {
            RootInvocation ri = this.getRootInvocation();
            return ri.root.getChildAddresses(ri.pathAddress.append(address));
        }
        return this.getChildAddresses((ListIterator<PathElement>)address.iterator());
    }

    abstract Set<PathElement> getChildAddresses(ListIterator<PathElement> var1);

    @Override
    public final ProxyController getProxyController(PathAddress address) {
        if (this.parent != null) {
            RootInvocation ri = this.getRootInvocation();
            return ri.root.getProxyController(ri.pathAddress.append(address));
        }
        return this.getProxyController((ListIterator<PathElement>)address.iterator());
    }

    abstract ProxyController getProxyController(ListIterator<PathElement> var1);

    @Override
    public final Set<ProxyController> getProxyControllers(PathAddress address) {
        if (this.parent != null) {
            RootInvocation ri = this.getRootInvocation();
            return ri.root.getProxyControllers(ri.pathAddress.append(address));
        }
        HashSet<ProxyController> controllers = new HashSet<ProxyController>();
        this.getProxyControllers((ListIterator<PathElement>)address.iterator(), controllers);
        return controllers;
    }

    abstract void getProxyControllers(ListIterator<PathElement> var1, Set<ProxyController> var2);

    @Override
    public final ManagementResourceRegistration getOverrideModel(String name) {
        if (name == null) {
            throw ControllerMessages.MESSAGES.nullVar("name");
        }
        if (this.parent == null) {
            throw ControllerMessages.MESSAGES.cannotOverrideRootRegistration();
        }
        if (!"*".equals(this.valueString)) {
            throw ControllerMessages.MESSAGES.cannotOverrideNonWildCardRegistration(this.valueString);
        }
        PathElement pe = PathElement.pathElement(this.parent.getKeyName(), name);
        return this.parent.getParent().getSubModel(PathAddress.pathAddress(pe));
    }

    @Override
    public final ManagementResourceRegistration getSubModel(PathAddress address) {
        return this.getSubRegistration(address);
    }

    final AbstractResourceRegistration getSubRegistration(PathAddress address) {
        if (this.parent != null) {
            RootInvocation ri = this.getRootInvocation();
            return ri.root.getSubRegistration(ri.pathAddress.append(address));
        }
        return this.getResourceRegistration((ListIterator<PathElement>)address.iterator());
    }

    abstract AbstractResourceRegistration getResourceRegistration(ListIterator<PathElement> var1);

    public final String getValueString() {
        return this.valueString;
    }

    final String getLocationString() {
        if (this.parent == null) {
            return "";
        }
        return this.parent.getLocationString() + this.valueString + ")";
    }

    final void getInheritedOperations(Map<String, OperationEntry> providers, boolean skipSelf) {
        if (!skipSelf) {
            this.getInheritedOperationEntries(providers);
        }
        if (this.parent != null) {
            this.parent.getParent().getInheritedOperations(providers, false);
        }
    }

    boolean hasNoAlternativeWildcardRegistration() {
        return this.parent == null || "*".equals(this.valueString) || !this.parent.getChildNames().contains("*");
    }

    abstract void getInheritedOperationEntries(Map<String, OperationEntry> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RootInvocation getRootInvocation() {
        RootInvocation result = null;
        if (this.parent != null) {
            AbstractResourceRegistration abstractResourceRegistration = this;
            synchronized (abstractResourceRegistration) {
                if (this.rootInvocation == null) {
                    NodeSubregistry ancestorSubregistry = this.parent;
                    AbstractResourceRegistration ancestorReg = this;
                    ArrayList<PathElement> path = new ArrayList<PathElement>();
                    while (ancestorSubregistry != null) {
                        PathElement pe = PathElement.pathElement(ancestorSubregistry.getKeyName(), ancestorReg.valueString);
                        path.add(0, pe);
                        ancestorReg = ancestorSubregistry.getParent();
                        ancestorSubregistry = ancestorReg.parent;
                    }
                    PathAddress pa = PathAddress.pathAddress(path);
                    this.rootInvocation = new RootInvocation(ancestorReg, pa);
                }
                result = this.rootInvocation;
            }
        }
        return result;
    }

    protected AbstractResourceRegistration getRootResourceRegistration() {
        if (this.parent == null) {
            return this;
        }
        RootInvocation invocation = this.getRootInvocation();
        return invocation.root;
    }

    @Override
    public void registerAlias(PathElement address, AliasEntry alias) {
        PathAddress myaddr;
        RootInvocation rootInvocation = this.parent == null ? null : this.getRootInvocation();
        AbstractResourceRegistration root = rootInvocation == null ? this : rootInvocation.root;
        PathAddress pathAddress = myaddr = rootInvocation == null ? PathAddress.EMPTY_ADDRESS : rootInvocation.pathAddress;
        assert (alias.getTarget() instanceof AbstractResourceRegistration) : "Unknown alias type";
        AbstractResourceRegistration tgtReg = (AbstractResourceRegistration)alias.getTarget();
        PathAddress targetAddress = tgtReg.parent == null ? PathAddress.EMPTY_ADDRESS : tgtReg.getRootInvocation().pathAddress;
        alias.setAddresses(targetAddress, myaddr.append(address));
        AbstractResourceRegistration target = (AbstractResourceRegistration)root.getSubModel(alias.getTargetAddress());
        if (target == null) {
            throw ControllerMessages.MESSAGES.aliasTargetResourceRegistrationNotFound(alias.getTargetAddress());
        }
        this.registerAlias(address, alias, target);
    }

    protected abstract void registerAlias(PathElement var1, AliasEntry var2, AbstractResourceRegistration var3);

    @Override
    public boolean isAlias() {
        return false;
    }

    @Override
    public AliasEntry getAliasEntry() {
        throw ControllerMessages.MESSAGES.resourceRegistrationIsNotAnAlias();
    }

    private static class OverrideDescriptionCombiner
    implements DescriptionProvider {
        private final DescriptionProvider mainDescriptionProvider;
        private final OverrideDescriptionProvider overrideDescriptionProvider;

        private OverrideDescriptionCombiner(DescriptionProvider mainDescriptionProvider, OverrideDescriptionProvider overrideDescriptionProvider) {
            this.mainDescriptionProvider = mainDescriptionProvider;
            this.overrideDescriptionProvider = overrideDescriptionProvider;
        }

        @Override
        public ModelNode getModelDescription(Locale locale) {
            ModelNode result = this.mainDescriptionProvider.getModelDescription(locale);
            ModelNode attrs = result.get("attributes");
            for (Map.Entry<String, ModelNode> entry : this.overrideDescriptionProvider.getAttributeOverrideDescriptions(locale).entrySet()) {
                attrs.get(entry.getKey()).set(entry.getValue());
            }
            ModelNode children = result.get("attributes");
            for (Map.Entry<String, ModelNode> entry : this.overrideDescriptionProvider.getChildTypeOverrideDescriptions(locale).entrySet()) {
                children.get(entry.getKey()).set(entry.getValue());
            }
            return result;
        }
    }

    private static class RootInvocation {
        final AbstractResourceRegistration root;
        final PathAddress pathAddress;

        RootInvocation(AbstractResourceRegistration root, PathAddress pathAddress) {
            this.root = root;
            this.pathAddress = pathAddress;
        }
    }
}

