/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.security.AccessController;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.remote.SecurityActions;
import org.jboss.as.protocol.mgmt.support.ManagementChannelInitialization;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.JBossThreadFactory;

public abstract class AbstractModelControllerOperationHandlerFactoryService
implements Service<AbstractModelControllerOperationHandlerFactoryService>,
ManagementChannelInitialization {
    public static final ServiceName OPERATION_HANDLER_NAME_SUFFIX;
    protected static final int CHANNEL_SHUTDOWN_TIMEOUT;
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executor = new InjectedValue();
    private static final int WORK_QUEUE_SIZE = 4096;
    private static final int POOL_CORE_SIZE = 4;
    private static final int POOL_MAX_SIZE = 16;

    public InjectedValue<ModelController> getModelControllerInjector() {
        return this.modelControllerValue;
    }

    public InjectedValue<ExecutorService> getExecutorInjector() {
        return this.executor;
    }

    protected String getThreadGroupName() {
        return "management-handler-thread";
    }

    @Override
    public synchronized void start(StartContext context) throws StartException {
        ControllerLogger.SERVER_MANAGEMENT_LOGGER.debugf("Starting operation handler service %s", (Object)context.getController().getName());
        if (this.executor.getOptionalValue() == null) {
            LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(4096);
            JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup(this.getThreadGroupName()), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(4, 16, 60L, TimeUnit.SECONDS, workQueue, threadFactory);
            executorService.allowCoreThreadTimeOut(true);
            this.getExecutorInjector().inject(executorService);
        }
    }

    @Override
    public synchronized void stop(StopContext context) {
    }

    @Override
    public synchronized AbstractModelControllerOperationHandlerFactoryService getValue() throws IllegalStateException {
        return this;
    }

    protected ModelController getController() {
        return this.modelControllerValue.getValue();
    }

    protected ExecutorService getExecutor() {
        return this.executor.getValue();
    }

    static {
        int timeout;
        OPERATION_HANDLER_NAME_SUFFIX = ServiceName.of("operation", "handler");
        String prop = null;
        try {
            prop = SecurityActions.getSystemProperty("jboss.as.management.channel.close.timeout", "15000");
            timeout = Integer.parseInt(prop);
        }
        catch (NumberFormatException e) {
            ControllerLogger.ROOT_LOGGER.invalidChannelCloseTimeout(e, "jboss.as.management.channel.close.timeout", prop);
            timeout = 15000;
        }
        CHANNEL_SHUTDOWN_TIMEOUT = timeout;
    }
}

