/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.DataInput;
import java.io.IOException;
import javax.security.auth.Subject;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.remote.OperationAttachmentsProxy;
import org.jboss.as.controller.remote.OperationMessageHandlerProxy;
import org.jboss.as.controller.remote.SecurityActions;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.dmr.ModelNode;

public class ModelControllerClientOperationHandler
implements ManagementRequestHandlerFactory {
    private final ModelController controller;
    private final ManagementChannelAssociation channelAssociation;
    private final Subject subject;

    public ModelControllerClientOperationHandler(ModelController controller, ManagementChannelAssociation channelAssociation) {
        this(controller, channelAssociation, null);
    }

    public ModelControllerClientOperationHandler(ModelController controller, ManagementChannelAssociation channelAssociation, Subject subject) {
        this.controller = controller;
        this.channelAssociation = channelAssociation;
        this.subject = subject;
    }

    @Override
    public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader header) {
        switch (header.getOperationId()) {
            case 69: 
            case 70: {
                handlers.registerActiveOperation(header.getBatchId(), null);
                return new ExecuteRequestHandler();
            }
            case 77: {
                return new CancelAsyncRequestHandler();
            }
        }
        return handlers.resolveNext();
    }

    private static class CancelAsyncRequestHandler
    implements ManagementRequestHandler<ModelNode, Void> {
        private CancelAsyncRequestHandler() {
        }

        @Override
        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            context.executeAsync(new ManagementRequestContext.AsyncTask<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute(ManagementRequestContext<Void> context) throws Exception {
                    ManagementResponseHeader response = ManagementResponseHeader.create(context.getRequestHeader());
                    FlushableDataOutput output = context.writeMessage(response);
                    try {
                        output.writeByte(36);
                        output.close();
                    }
                    finally {
                        StreamUtils.safeClose(output);
                    }
                }
            });
            resultHandler.cancel();
        }
    }

    class ExecuteRequestHandler
    implements ManagementRequestHandler<ModelNode, Void> {
        ExecuteRequestHandler() {
        }

        @Override
        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            final ModelNode operation = new ModelNode();
            ProtocolUtils.expectHeader(input, 97);
            operation.readExternal(input);
            ProtocolUtils.expectHeader(input, 101);
            final int attachmentsLength = input.readInt();
            context.executeAsync(new ManagementRequestContext.AsyncTask<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute(ManagementRequestContext<Void> context) throws Exception {
                    ModelNode result;
                    ManagementResponseHeader response = ManagementResponseHeader.create(context.getRequestHeader());
                    SecurityActions.setSecurityContextSubject(ModelControllerClientOperationHandler.this.subject);
                    try {
                        result = ExecuteRequestHandler.this.doExecute(operation, attachmentsLength, context);
                    }
                    finally {
                        SecurityActions.clearSubjectSecurityContext();
                    }
                    FlushableDataOutput output = context.writeMessage(response);
                    try {
                        output.write(100);
                        result.writeExternal(output);
                        output.writeByte(36);
                        output.close();
                    }
                    finally {
                        StreamUtils.safeClose(output);
                    }
                    resultHandler.done(result);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ModelNode doExecute(ModelNode operation, int attachmentsLength, ManagementRequestContext<Void> context) {
            operation.get("operation-headers", "caller-type").set("user");
            ManagementRequestHeader header = (ManagementRequestHeader)ManagementRequestHeader.class.cast(context.getRequestHeader());
            int batchId = header.getBatchId();
            ModelNode result = new ModelNode();
            OperationMessageHandlerProxy messageHandlerProxy = new OperationMessageHandlerProxy(ModelControllerClientOperationHandler.this.channelAssociation, batchId);
            OperationAttachmentsProxy attachmentsProxy = OperationAttachmentsProxy.create(ModelControllerClientOperationHandler.this.channelAssociation, batchId, attachmentsLength);
            try {
                ControllerLogger.ROOT_LOGGER.tracef("Executing client request %d(%d)", (Object)batchId, (Object)header.getRequestId());
                result.set(ModelControllerClientOperationHandler.this.controller.execute(operation, messageHandlerProxy, ModelController.OperationTransactionControl.COMMIT, attachmentsProxy));
            }
            catch (Exception e) {
                ModelNode failure = new ModelNode();
                failure.get("outcome").set("failed");
                failure.get("failure-description").set(e.getClass().getName() + ":" + e.getMessage());
                result.set(failure);
                attachmentsProxy.shutdown(e);
            }
            finally {
                ControllerLogger.ROOT_LOGGER.tracef("Executed client request %d", (Object)batchId);
            }
            return result;
        }
    }
}

