/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.remote.Pipe;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ProtocolUtils;

class OperationAttachmentsProxy
implements OperationAttachments {
    final List<ProxiedInputStream> proxiedStreams;

    public OperationAttachmentsProxy(ManagementChannelAssociation channelAssociation, int batchId, int size) {
        this.proxiedStreams = new ArrayList<ProxiedInputStream>(size);
        for (int i = 0; i < size; ++i) {
            this.proxiedStreams.add(new ProxiedInputStream(channelAssociation, batchId, i));
        }
    }

    static OperationAttachmentsProxy create(ManagementChannelAssociation channelAssociation, int batchId, int size) {
        return new OperationAttachmentsProxy(channelAssociation, batchId, size);
    }

    @Override
    public boolean isAutoCloseStreams() {
        return false;
    }

    @Override
    public List<InputStream> getInputStreams() {
        ArrayList<ProxiedInputStream> result = new ArrayList<ProxiedInputStream>();
        result.addAll(this.proxiedStreams);
        return Collections.unmodifiableList(result);
    }

    @Override
    public void close() throws IOException {
    }

    void shutdown(Exception error) {
        for (ProxiedInputStream stream : this.proxiedStreams) {
            stream.shutdown(error);
        }
    }

    public static class ProxiedInputStream
    extends InputStream {
        static final int BUFFER_SIZE = 8192;
        private final int index;
        private final int batchId;
        private volatile Pipe pipe = new Pipe(8192);
        private final ManagementChannelAssociation channelAssociation;
        private volatile boolean initialized;
        private volatile Exception error;

        ProxiedInputStream(ManagementChannelAssociation channelAssociation, int batchId, int index) {
            this.channelAssociation = channelAssociation;
            this.batchId = batchId;
            this.index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            if (!this.initialized && this.error == null) {
                ProxiedInputStream proxiedInputStream = this;
                synchronized (proxiedInputStream) {
                    if (!this.initialized) {
                        this.initializeBytes();
                    }
                }
            }
            if (this.error != null) {
                if (this.error instanceof IOException) {
                    throw (IOException)this.error;
                }
                throw new IOException(this.error);
            }
            return this.pipe.getIn().read();
        }

        void initializeBytes() {
            if (!this.initialized) {
                this.initialized = true;
                try {
                    final OutputStream os = this.pipe.getOut();
                    this.channelAssociation.executeRequest(this.batchId, new AbstractManagementRequest<Object, Object>(){

                        @Override
                        public byte getOperationType() {
                            return 76;
                        }

                        @Override
                        protected void sendRequest(ActiveOperation.ResultHandler<Object> resultHandler, ManagementRequestContext<Object> context, FlushableDataOutput output) throws IOException {
                            output.write(102);
                            output.writeInt(ProxiedInputStream.this.index);
                        }

                        @Override
                        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Object> resultHandler, ManagementRequestContext<Object> context) throws IOException {
                            try {
                                int len;
                                ProtocolUtils.expectHeader(input, 103);
                                int size = input.readInt();
                                ProtocolUtils.expectHeader(input, 104);
                                byte[] buffer = new byte[8192];
                                for (int totalRead = 0; totalRead < size; totalRead += len) {
                                    len = Math.min(size - totalRead, buffer.length);
                                    input.readFully(buffer, 0, len);
                                    os.write(buffer, 0, len);
                                }
                                os.close();
                            }
                            catch (IOException e) {
                                ProxiedInputStream.this.shutdown(e);
                                throw e;
                            }
                        }
                    });
                }
                catch (IOException e) {
                    this.shutdown(e);
                }
            }
        }

        void shutdown(Exception error) {
            StreamUtils.safeClose(this);
            this.error = error;
        }

        @Override
        public void close() throws IOException {
            IOException ex = null;
            try {
                this.pipe.getOut().close();
            }
            catch (IOException e) {
                ex = e;
            }
            try {
                this.pipe.getIn().close();
            }
            catch (IOException e) {
                ex = e;
            }
            if (ex != null) {
                throw ex;
            }
        }
    }
}

