/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.impl.AbstractDelegatingAsyncFuture;
import org.jboss.as.controller.remote.TransactionalOperationImpl;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

class TransactionalProtocolClientImpl
implements ManagementRequestHandlerFactory,
TransactionalProtocolClient {
    private final ManagementChannelAssociation channelAssociation;

    public TransactionalProtocolClientImpl(ManagementChannelAssociation channelAssociation) {
        assert (channelAssociation != null);
        this.channelAssociation = channelAssociation;
    }

    @Override
    public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader header) {
        byte operationType = header.getOperationId();
        if (operationType == 72) {
            return new HandleReportRequestHandler();
        }
        if (operationType == 76) {
            return ReadAttachmentInputStreamRequestHandler.INSTANCE;
        }
        return handlers.resolveNext();
    }

    @Override
    public AsyncFuture<ModelNode> execute(TransactionalProtocolClient.TransactionalOperationListener<TransactionalProtocolClient.Operation> listener, ModelNode operation, OperationMessageHandler messageHandler, OperationAttachments attachments) throws IOException {
        TransactionalOperationImpl wrapper = new TransactionalOperationImpl(operation, messageHandler, attachments);
        return this.execute(listener, wrapper);
    }

    @Override
    public <T extends TransactionalProtocolClient.Operation> AsyncFuture<ModelNode> execute(TransactionalProtocolClient.TransactionalOperationListener<T> listener, T operation) throws IOException {
        ExecuteRequestContext context = new ExecuteRequestContext(new OperationWrapper<T>(listener, operation));
        final ActiveOperation<ModelNode, ExecuteRequestContext> op = this.channelAssociation.initializeOperation(context, context);
        AbstractDelegatingAsyncFuture<ModelNode> result = new AbstractDelegatingAsyncFuture<ModelNode>(op.getResult()){

            @Override
            public void asyncCancel(boolean interruptionDesired) {
                try {
                    TransactionalProtocolClientImpl.this.channelAssociation.executeRequest(op, new CompleteTxRequest(113));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        context.initialize((AsyncFuture<ModelNode>)result);
        this.channelAssociation.executeRequest(op, new ExecuteRequest());
        return result;
    }

    static ModelNode getFailureResponse(String outcome, String message) {
        ModelNode response = new ModelNode();
        response.get("outcome").set(outcome);
        if (message != null) {
            response.get("failure-description").set(message);
        }
        return response;
    }

    static ModelNode getResponse(String outcome) {
        return TransactionalProtocolClientImpl.getFailureResponse(outcome, null);
    }

    static class PreparedOperationImpl<T extends TransactionalProtocolClient.Operation>
    implements TransactionalProtocolClient.PreparedOperation<T> {
        private final T operation;
        private final ModelNode preparedResult;
        private final AsyncFuture<ModelNode> finalResult;
        private final ModelController.OperationTransaction transaction;

        protected PreparedOperationImpl(T operation, ModelNode preparedResult, AsyncFuture<ModelNode> finalResult, ModelController.OperationTransaction transaction) {
            assert (finalResult != null) : "null result";
            this.operation = operation;
            this.preparedResult = preparedResult;
            this.finalResult = finalResult;
            this.transaction = transaction;
        }

        @Override
        public T getOperation() {
            return this.operation;
        }

        @Override
        public ModelNode getPreparedResult() {
            return this.preparedResult;
        }

        @Override
        public boolean isFailed() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.finalResult.isDone();
        }

        @Override
        public AsyncFuture<ModelNode> getFinalResult() {
            return this.finalResult;
        }

        @Override
        public void commit() {
            this.transaction.commit();
        }

        @Override
        public void rollback() {
            this.transaction.rollback();
        }
    }

    private static class OperationWrapper<T extends TransactionalProtocolClient.Operation> {
        private final T operation;
        private final TransactionalProtocolClient.TransactionalOperationListener<T> listener;
        private AsyncFuture<ModelNode> future;

        OperationWrapper(TransactionalProtocolClient.TransactionalOperationListener<T> listener, T operation) {
            this.listener = listener;
            this.operation = operation;
        }

        OperationMessageHandler getMessageHandler() {
            return this.operation.getMessageHandler();
        }

        ModelNode getOperation() {
            return this.operation.getOperation();
        }

        OperationAttachments getAttachments() {
            return this.operation.getAttachments();
        }

        void prepared(ModelController.OperationTransaction transaction, ModelNode result) {
            PreparedOperationImpl<T> preparedOperation = new PreparedOperationImpl<T>(this.operation, result, this.future, transaction);
            this.listener.operationPrepared(preparedOperation);
        }

        void completed(ModelNode response) {
            this.listener.operationComplete(this.operation, response);
        }

        void failed(ModelNode response) {
            this.listener.operationFailed(this.operation, response);
        }
    }

    static class ExecuteRequestContext
    implements ActiveOperation.CompletedCallback<ModelNode> {
        final OperationWrapper<?> wrapper;
        final AtomicBoolean completed = new AtomicBoolean(false);

        ExecuteRequestContext(OperationWrapper<?> operationWrapper) {
            this.wrapper = operationWrapper;
        }

        void initialize(AsyncFuture<ModelNode> result) {
            ((OperationWrapper)this.wrapper).future = result;
        }

        OperationMessageHandler getMessageHandler() {
            return this.wrapper.getMessageHandler();
        }

        ModelNode getOperation() {
            return this.wrapper.getOperation();
        }

        OperationAttachments getAttachments() {
            return this.wrapper.getAttachments();
        }

        List<InputStream> getInputStreams() {
            OperationAttachments attachments = this.getAttachments();
            if (attachments == null) {
                return Collections.emptyList();
            }
            return attachments.getInputStreams();
        }

        @Override
        public synchronized void completed(ModelNode result) {
            if (this.completed.compareAndSet(false, true)) {
                this.wrapper.completed(result);
            }
        }

        @Override
        public void failed(Exception e) {
            this.operationFailed(TransactionalProtocolClientImpl.getFailureResponse("failed", e.getMessage()));
        }

        @Override
        public void cancelled() {
            this.operationFailed(TransactionalProtocolClientImpl.getResponse("cancelled"));
        }

        synchronized void operationFailed(ModelNode response) {
            if (this.completed.compareAndSet(false, true)) {
                this.wrapper.failed(response);
            }
        }

        synchronized void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
            this.wrapper.prepared(transaction, result);
        }
    }

    private static class ReadAttachmentInputStreamRequestHandler
    implements ManagementRequestHandler<ModelNode, ExecuteRequestContext> {
        static final ReadAttachmentInputStreamRequestHandler INSTANCE = new ReadAttachmentInputStreamRequestHandler();

        private ReadAttachmentInputStreamRequestHandler() {
        }

        @Override
        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ProtocolUtils.expectHeader(input, 102);
            final int index = input.readInt();
            context.executeAsync(new ManagementRequestContext.AsyncTask<ExecuteRequestContext>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute(ManagementRequestContext<ExecuteRequestContext> context) throws Exception {
                    ExecuteRequestContext exec = context.getAttachment();
                    ManagementRequestHeader header = (ManagementRequestHeader)ManagementRequestHeader.class.cast(context.getRequestHeader());
                    ManagementResponseHeader response = new ManagementResponseHeader(header.getVersion(), header.getRequestId(), null);
                    InputStream is = exec.getAttachments().getInputStreams().get(index);
                    ByteArrayOutputStream bout = ReadAttachmentInputStreamRequestHandler.this.copyStream(is);
                    FlushableDataOutput output = context.writeMessage(response);
                    try {
                        output.writeByte(103);
                        output.writeInt(bout.size());
                        output.writeByte(104);
                        output.write(bout.toByteArray());
                        output.writeByte(36);
                        output.close();
                    }
                    finally {
                        StreamUtils.safeClose(output);
                    }
                }
            });
        }

        protected ByteArrayOutputStream copyStream(InputStream is) throws IOException {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            if (is != null) {
                StreamUtils.copyStream(is, bout);
            }
            return bout;
        }
    }

    private static class HandleReportRequestHandler
    implements ManagementRequestHandler<ModelNode, ExecuteRequestContext> {
        private HandleReportRequestHandler() {
        }

        @Override
        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ProtocolUtils.expectHeader(input, 98);
            MessageSeverity severity = Enum.valueOf(MessageSeverity.class, input.readUTF());
            ProtocolUtils.expectHeader(input, 99);
            String message = input.readUTF();
            ProtocolUtils.expectHeader(input, 21);
            ExecuteRequestContext requestContext = context.getAttachment();
            OperationMessageHandler handler = requestContext.getMessageHandler();
            handler.handleReport(severity, message);
        }
    }

    private static class CompleteTxRequest
    extends AbstractManagementRequest<ModelNode, ExecuteRequestContext> {
        private final byte status;

        private CompleteTxRequest(byte status) {
            this.status = status;
        }

        @Override
        public byte getOperationType() {
            return 78;
        }

        @Override
        protected void sendRequest(ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<ExecuteRequestContext> context, FlushableDataOutput output) throws IOException {
            output.write(this.status);
        }

        @Override
        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ProtocolUtils.expectHeader(input, 74);
            ModelNode response = new ModelNode();
            response.readExternal(input);
            resultHandler.done(response);
        }
    }

    private class ExecuteRequest
    extends AbstractManagementRequest<ModelNode, ExecuteRequestContext> {
        private ExecuteRequest() {
        }

        @Override
        public byte getOperationType() {
            return 71;
        }

        @Override
        protected void sendRequest(ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<ExecuteRequestContext> context, FlushableDataOutput output) throws IOException {
            ExecuteRequestContext executionContext = context.getAttachment();
            List<InputStream> streams = executionContext.getInputStreams();
            ModelNode operation = executionContext.getOperation();
            int inputStreamLength = 0;
            if (streams != null) {
                inputStreamLength = streams.size();
            }
            output.write(97);
            operation.writeExternal(output);
            output.write(101);
            output.writeInt(inputStreamLength);
        }

        @Override
        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<ModelNode> resultHandler, final ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            byte responseType = input.readByte();
            ModelNode response = new ModelNode();
            response.readExternal(input);
            boolean prepared = responseType == 75;
            ExecuteRequestContext executeRequestContext = context.getAttachment();
            if (prepared) {
                executeRequestContext.operationPrepared(new ModelController.OperationTransaction(){

                    @Override
                    public void rollback() {
                        this.done(false);
                    }

                    @Override
                    public void commit() {
                        this.done(true);
                    }

                    private void done(boolean commit) {
                        byte status = commit ? (byte)112 : 113;
                        try {
                            TransactionalProtocolClientImpl.this.channelAssociation.executeRequest(context.getOperationId(), new CompleteTxRequest(status));
                        }
                        catch (Exception e) {
                            resultHandler.failed(e);
                        }
                    }
                }, response);
            } else {
                executeRequestContext.operationFailed(response);
                resultHandler.done(response);
            }
        }
    }
}

