/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.resource;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SocketBindingGroupResourceDefinition
extends SimpleResourceDefinition {
    public static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setResourceOnly()).setValidator(new StringLengthValidator(1)).build();
    public static final SimpleAttributeDefinition DEFAULT_INTERFACE = new SimpleAttributeDefinitionBuilder("default-interface", ModelType.STRING, false).setAllowExpression(true).setValidator(new StringLengthValidator(1, Integer.MAX_VALUE, false, true)).setFlags(AttributeAccess.Flag.RESTART_ALL_SERVICES).build();
    public static final SimpleAttributeDefinition PORT_OFFSET = new SimpleAttributeDefinitionBuilder("port-offset", ModelType.INT, true).setAllowExpression(true).setValidator(new IntRangeValidator(-65535, 65535, true, true)).setDefaultValue(new ModelNode().set(0)).setFlags(AttributeAccess.Flag.RESTART_ALL_SERVICES).build();
    public static final ListAttributeDefinition INCLUDES = ((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)new PrimitiveListAttributeDefinition.Builder("includes", ModelType.STRING).setXmlName(Element.INCLUDE.getLocalName())).setAllowNull(true)).setMinSize(0)).setMaxSize(Integer.MAX_VALUE)).setValidator(new StringLengthValidator(1, true))).setAttributeMarshaller(new AttributeMarshaller(){

        @Override
        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (this.isMarshallable(attribute, resourceModel)) {
                for (ModelNode included : resourceModel.get(attribute.getName()).asList()) {
                    writer.writeEmptyElement(attribute.getXmlName());
                    writer.writeAttribute(Attribute.SOCKET_BINDING_GROUP.getLocalName(), included.asString());
                }
            }
        }
    })).setFlags(AttributeAccess.Flag.RESTART_JVM)).build();
    private final boolean forDomainModel;
    private final ResourceDefinition[] children;

    public SocketBindingGroupResourceDefinition(OperationStepHandler addHandler, OperationStepHandler removeHandler, boolean forDomainModel, ResourceDefinition ... children) {
        super(PathElement.pathElement("socket-binding-group"), ControllerResolver.getResolver("socket-binding-group"), addHandler, removeHandler, OperationEntry.Flag.RESTART_ALL_SERVICES, OperationEntry.Flag.RESTART_ALL_SERVICES);
        this.forDomainModel = forDomainModel;
        this.children = children;
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadOnlyAttribute(NAME, null);
        resourceRegistration.registerReadWriteAttribute(DEFAULT_INTERFACE, null, new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{DEFAULT_INTERFACE}){

            @Override
            protected void validateUpdatedModel(OperationContext context, Resource model) throws OperationFailedException {
                SocketBindingGroupResourceDefinition.validateDefaultInterfaceReference(context, model.getModel());
            }
        });
        if (!this.forDomainModel) {
            resourceRegistration.registerReadWriteAttribute(PORT_OFFSET, null, new ReloadRequiredWriteAttributeHandler(PORT_OFFSET));
        }
    }

    @Override
    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
    }

    @Override
    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        for (ResourceDefinition child : this.children) {
            resourceRegistration.registerSubModel(child);
        }
    }

    public static void validateDefaultInterfaceReference(OperationContext context, ModelNode bindingGroup) throws OperationFailedException {
        ModelNode defaultInterfaceNode = bindingGroup.get(DEFAULT_INTERFACE.getName());
        if (defaultInterfaceNode.getType() == ModelType.STRING) {
            String defaultInterface = defaultInterfaceNode.asString();
            PathAddress interfaceAddress = PathAddress.pathAddress(PathElement.pathElement("interface", defaultInterface));
            try {
                context.readResourceFromRoot(interfaceAddress, false);
            }
            catch (RuntimeException e) {
                throw ControllerMessages.MESSAGES.nonexistentInterface(defaultInterface, DEFAULT_INTERFACE.getName());
            }
        }
    }
}

