/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.services.path;

import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.dmr.ModelNode;

class PathWriteAttributeHandler
extends WriteAttributeHandlers.WriteAttributeOperationHandler {
    private final PathManagerService pathManager;
    private final boolean services;

    PathWriteAttributeHandler(PathManagerService pathManager, SimpleAttributeDefinition definition, boolean services) {
        super(definition.getValidator());
        this.pathManager = pathManager;
        this.services = services;
    }

    @Override
    protected void modelChanged(OperationContext context, ModelNode operation, final String attributeName, final ModelNode newValue, final ModelNode currentValue) throws OperationFailedException {
        final String pathName = PathAddress.pathAddress(operation.get("address")).getLastElement().getValue();
        ModelNode model = Resource.Tools.readModel(context.readResource(PathAddress.EMPTY_ADDRESS));
        if (model.get(PathResourceDefinition.READ_ONLY.getName()).asBoolean(false)) {
            throw ControllerMessages.MESSAGES.cannotModifyReadOnlyPath(pathName);
        }
        if (this.services) {
            final PathEntry pathEntry = this.pathManager.getPathEntry(pathName);
            if (pathEntry.isReadOnly()) {
                throw ControllerMessages.MESSAGES.pathEntryIsReadOnly(operation.require("address").asString());
            }
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    final PathEntry backup = new PathEntry(pathEntry);
                    ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                    final PathManagerService.PathEventContextImpl pathEventContext = PathWriteAttributeHandler.this.pathManager.checkRestartRequired(context, pathName, PathManager.Event.UPDATED);
                    if (pathEventContext.isInstallServices()) {
                        if (attributeName.equals("path")) {
                            PathWriteAttributeHandler.this.pathManager.changePath(pathName, newValue.asString());
                            PathWriteAttributeHandler.this.pathManager.changePathServices(context, pathName, newValue.asString(), verificationHandler);
                        } else if (attributeName.equals("relative-to")) {
                            PathWriteAttributeHandler.this.pathManager.changeRelativePath(pathName, newValue.isDefined() ? newValue.asString() : null, true);
                            PathWriteAttributeHandler.this.pathManager.changeRelativePathServices(context, pathName, newValue.isDefined() ? newValue.asString() : null, verificationHandler);
                        }
                    }
                    context.addStep(verificationHandler, OperationContext.Stage.VERIFY);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        @Override
                        public void handleRollback(OperationContext context, ModelNode operation) {
                            if (pathEventContext.isInstallServices()) {
                                if (attributeName.equals("path")) {
                                    PathWriteAttributeHandler.this.pathManager.changePath(pathName, backup.getPath());
                                    PathWriteAttributeHandler.this.pathManager.changePathServices(context, pathName, currentValue.asString(), null);
                                } else if (attributeName.equals("relative-to")) {
                                    try {
                                        PathWriteAttributeHandler.this.pathManager.changeRelativePath(pathName, backup.getRelativeTo(), false);
                                    }
                                    catch (OperationFailedException e) {
                                        throw new RuntimeException(e);
                                    }
                                    PathWriteAttributeHandler.this.pathManager.changeRelativePathServices(context, pathName, currentValue.isDefined() ? currentValue.asString() : null, null);
                                }
                            } else {
                                pathEventContext.revert();
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }
}

