/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.HashMap;
import java.util.Locale;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.global.ReadResourceHandler;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformationTargetImpl;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReadTransformedResourceOperation
implements OperationStepHandler {
    private final ParametersValidator validator = new ParametersValidator();
    public static DescriptionProvider DESCRIPTION = new DescriptionProvider(){

        @Override
        public ModelNode getModelDescription(Locale locale) {
            return new ModelNode();
        }
    };
    private final TransformerRegistry transformerRegistry;

    public ReadTransformedResourceOperation(TransformerRegistry transformerRegistry) {
        this.validator.registerValidator("subsystem", new ModelTypeValidator(ModelType.STRING, false));
        this.transformerRegistry = transformerRegistry;
    }

    private ModelNode transformReadResourceResult(OperationContext context, ModelNode original, String subsystem, ModelVersion version) throws OperationFailedException {
        ModelNode rootData = original.get("result");
        HashMap<PathAddress, ModelVersion> subsystemVersions = new HashMap<PathAddress, ModelVersion>();
        subsystemVersions.put(PathAddress.EMPTY_ADDRESS.append("subsystem", subsystem), version);
        TransformationTargetImpl target = TransformationTargetImpl.create(this.transformerRegistry, ModelVersion.create(1, 0, 0), subsystemVersions, null, TransformationTarget.TransformationTargetType.SERVER);
        Transformers transformers = Transformers.Factory.create(target);
        ResourceTransformationContext ctx = Transformers.Factory.getTransformationContext(target, context);
        ImmutableManagementResourceRegistration rr = context.getRootResourceRegistration();
        Resource root = TransformerRegistry.modelToResource(rr, rootData, true);
        Resource transformed = transformers.transformResource(ctx, root);
        ModelNode model = Resource.Tools.readModel(transformed);
        return model;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final String subsystem = operation.get("subsystem").asString();
        int major = operation.get("management-major-version").asInt();
        int minor = operation.get("management-minor-version").asInt();
        int micro = operation.get("management-micro-version").asInt();
        final ModelVersion version = ModelVersion.create(major, minor, micro);
        final ModelNode readResourceResult = new ModelNode();
        context.addStep(new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode transformed = ReadTransformedResourceOperation.this.transformReadResourceResult(context, readResourceResult, subsystem, version);
                context.getResult().set(transformed);
                context.stepCompleted();
            }
        }, OperationContext.Stage.IMMEDIATE);
        ModelNode op = new ModelNode();
        op.get("operation").set("read-resource");
        op.get("address").set(PathAddress.EMPTY_ADDRESS.toModelNode());
        op.get("recursive").set(true);
        context.addStep(readResourceResult, op, ReadResourceHandler.INSTANCE, OperationContext.Stage.IMMEDIATE);
        context.stepCompleted();
    }
}

