/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.LegacyResourceDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class TransformationUtils {
    private TransformationUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelNode getSubsystemDefinitionForVersion(String subsystemName, ModelVersion version) {
        block17: {
            ModelNode modelNode;
            StringBuilder key = new StringBuilder(subsystemName).append("-").append(version.getMajor()).append(".").append(version.getMinor());
            if (version.getMicro() != 0) {
                key.append('.').append(version.getMicro());
            }
            key.append(".dmr");
            InputStream is = null;
            try {
                is = TransformerRegistry.class.getResourceAsStream(key.toString());
                if (is == null) {
                    ModelNode modelNode2 = null;
                    return modelNode2;
                }
                modelNode = ModelNode.fromStream(is);
            }
            catch (IOException e) {
                ControllerLogger.ROOT_LOGGER.cannotReadTargetDefinition(e);
                break block17;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            return modelNode;
        }
        return null;
    }

    public static ResourceDefinition loadSubsystemDefinition(String subsystemName, ModelVersion version) {
        ModelNode desc = TransformationUtils.getSubsystemDefinitionForVersion(subsystemName, version);
        if (desc == null) {
            return null;
        }
        return new LegacyResourceDefinition(desc);
    }

    public static Resource modelToResource(ImmutableManagementResourceRegistration reg, ModelNode model, boolean includeUndefined) {
        return TransformationUtils.modelToResource(reg, model, includeUndefined, PathAddress.EMPTY_ADDRESS);
    }

    private static Resource modelToResource(ImmutableManagementResourceRegistration reg, ModelNode model, boolean includeUndefined, PathAddress fullPath) {
        Resource res = Resource.Factory.create();
        ModelNode value = new ModelNode();
        HashSet<String> allFields = new HashSet<String>(model.keys());
        for (String name : reg.getAttributeNames(PathAddress.EMPTY_ADDRESS)) {
            AttributeAccess aa = reg.getAttributeAccess(PathAddress.EMPTY_ADDRESS, name);
            if (aa.getStorageType() == AttributeAccess.Storage.RUNTIME) {
                allFields.remove(name);
                continue;
            }
            if (includeUndefined) {
                value.get(name).set(model.get(name));
            } else if (model.hasDefined(name)) {
                value.get(name).set(model.get(name));
            }
            allFields.remove(name);
        }
        if (!value.isDefined() && model.isDefined() && reg.getChildAddresses(PathAddress.EMPTY_ADDRESS).size() == 0) {
            value.setEmptyObject();
        }
        res.writeModel(value);
        for (PathElement path : reg.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
            ModelNode subModel;
            ImmutableManagementResourceRegistration sub = reg.getSubModel(PathAddress.pathAddress(path));
            if (path.isWildcard()) {
                subModel = model.get(path.getKey());
                if (subModel.isDefined()) {
                    for (Property p : subModel.asPropertyList()) {
                        if (!p.getValue().isDefined()) continue;
                        res.registerChild(PathElement.pathElement(path.getKey(), p.getName()), TransformationUtils.modelToResource(sub, p.getValue(), includeUndefined, fullPath.append(path)));
                    }
                }
            } else {
                subModel = model.get(path.getKeyValuePair());
                if (subModel.isDefined()) {
                    res.registerChild(path, TransformationUtils.modelToResource(sub, subModel, includeUndefined, fullPath.append(path)));
                }
            }
            allFields.remove(path.getKey());
        }
        if (!allFields.isEmpty()) {
            throw ControllerMessages.MESSAGES.modelFieldsNotKnown(allFields, fullPath);
        }
        return res;
    }
}

