/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class TransformersImpl
implements Transformers {
    private static final Logger log = Logger.getLogger(TransformersImpl.class);
    private final TransformationTarget target;

    TransformersImpl(TransformationTarget target) {
        assert (target != null);
        this.target = target;
    }

    @Override
    public TransformationTarget getTarget() {
        return this.target;
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, ModelNode operation) throws OperationFailedException {
        String operationName;
        PathAddress address = PathAddress.pathAddress(operation.require("address"));
        OperationTransformer transformer = this.target.resolveTransformer(address, operationName = operation.require("operation").asString());
        if (transformer == null) {
            ControllerLogger.ROOT_LOGGER.tracef("operation %s does not need transformation", (Object)operation);
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }
        return transformer.transformOperation(context, address, operation);
    }

    @Override
    public Resource transformResource(ResourceTransformationContext context, Resource resource) throws OperationFailedException {
        ResourceTransformer transformer = this.target.resolveTransformer(PathAddress.EMPTY_ADDRESS);
        if (transformer == null) {
            ControllerLogger.ROOT_LOGGER.tracef("resource %s does not need transformation", (Object)resource);
            return resource;
        }
        transformer.transformResource(context, PathAddress.EMPTY_ADDRESS, resource);
        return context.getTransformedRoot();
    }
}

