/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jreadline.console.alias;

import org.jboss.jreadline.complete.CompleteOperation;
import org.jboss.jreadline.complete.Completion;
import org.jboss.jreadline.console.alias.AliasManager;
import org.jboss.jreadline.util.Parser;

public class AliasCompletion
implements Completion {
    private static final String ALIAS = "alias";
    private static final String ALIAS_SPACE = "alias ";
    private static final String UNALIAS = "unalias";
    private static final String UNALIAS_SPACE = "unalias ";
    private AliasManager manager;

    public AliasCompletion(AliasManager manager) {
        this.manager = manager;
    }

    @Override
    public void complete(CompleteOperation completeOperation) {
        completeOperation.addCompletionCandidates(this.manager.findAllMatchingNames(completeOperation.getBuffer().trim()));
        if (ALIAS.startsWith(completeOperation.getBuffer())) {
            completeOperation.addCompletionCandidate(ALIAS);
        } else if (UNALIAS.startsWith(completeOperation.getBuffer())) {
            completeOperation.addCompletionCandidate(UNALIAS);
        } else if (completeOperation.getBuffer().equals(ALIAS_SPACE) || completeOperation.getBuffer().equals(UNALIAS_SPACE)) {
            completeOperation.addCompletionCandidates(this.manager.getAllNames());
            completeOperation.setOffset(completeOperation.getCursor());
        } else if (completeOperation.getBuffer().startsWith(ALIAS_SPACE) || completeOperation.getBuffer().startsWith(UNALIAS_SPACE)) {
            String word = Parser.findWordClosestToCursor(completeOperation.getBuffer(), completeOperation.getCursor());
            completeOperation.addCompletionCandidates(this.manager.findAllMatchingNames(word));
            completeOperation.setOffset(completeOperation.getCursor() - word.length());
        }
    }
}

