/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jreadline.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.jreadline.complete.CompleteOperation;
import org.jboss.jreadline.console.Config;

public class Parser {
    private static final String spaceEscapedMatcher = "\\ ";
    private static final String SPACE = " ";
    private static final char SPACE_CHAR = ' ';
    private static final char SLASH = '\\';
    private static final Pattern spaceEscapedPattern = Pattern.compile("\\\\ ");
    private static final Pattern spacePattern = Pattern.compile(" ");

    public static String formatDisplayList(String[] displayList, int termHeight, int termWidth) {
        return Parser.formatDisplayList(Arrays.asList(displayList), termHeight, termWidth);
    }

    public static String formatDisplayList(List<String> displayList, int termHeight, int termWidth) {
        int numRows;
        if (displayList == null || displayList.size() < 1) {
            return "";
        }
        int maxLength = 0;
        for (String completion : displayList) {
            if (completion.length() <= maxLength) continue;
            maxLength = completion.length();
        }
        int numColumns = termWidth / (maxLength += 2);
        if (numColumns > displayList.size()) {
            numColumns = displayList.size();
        }
        if ((numRows = displayList.size() / numColumns) * numColumns < displayList.size()) {
            ++numRows;
        }
        StringBuilder completionOutput = new StringBuilder();
        for (int i = 0; i < numRows; ++i) {
            int fetch;
            for (int c = 0; c < numColumns && (fetch = i + c * numRows) < displayList.size(); ++c) {
                completionOutput.append(Parser.padRight(maxLength, displayList.get(i + c * numRows)));
            }
            completionOutput.append(Config.getLineSeparator());
        }
        return completionOutput.toString();
    }

    private static String padRight(int n, String s) {
        return String.format("%1$-" + n + "s", s);
    }

    public static String findStartsWithOperation(List<CompleteOperation> coList) {
        ArrayList<String> tmpList = new ArrayList<String>();
        for (CompleteOperation co : coList) {
            String s = Parser.findStartsWith(co.getFormattedCompletionCandidates());
            if (s.length() > 0) {
                tmpList.add(s);
                continue;
            }
            return "";
        }
        return Parser.findStartsWith(tmpList);
    }

    public static String findStartsWith(List<String> completionList) {
        StringBuilder builder = new StringBuilder();
        for (String completion : completionList) {
            while (builder.length() < completion.length() && Parser.startsWith(completion.substring(0, builder.length() + 1), completionList)) {
                builder.append(completion.charAt(builder.length()));
            }
        }
        return builder.toString();
    }

    private static boolean startsWith(String criteria, List<String> completionList) {
        for (String completion : completionList) {
            if (completion.startsWith(criteria)) continue;
            return false;
        }
        return true;
    }

    public static String findWordClosestToCursor(String text, int cursor) {
        if (text.length() <= cursor + 1) {
            if (text.contains(SPACE)) {
                if (Parser.doWordContainEscapedSpace(text)) {
                    if (Parser.doWordContainOnlyEscapedSpace(text)) {
                        return Parser.switchEscapedSpacesToSpacesInWord(text);
                    }
                    return Parser.switchEscapedSpacesToSpacesInWord(Parser.findEscapedSpaceWordCloseToEnd(text));
                }
                if (text.lastIndexOf(SPACE) >= cursor) {
                    return text.substring(text.substring(0, cursor).lastIndexOf(SPACE)).trim();
                }
                return text.substring(text.lastIndexOf(SPACE)).trim();
            }
            return text.trim();
        }
        String rest = text.length() > cursor + 1 ? text.substring(0, cursor + 1) : text;
        if (Parser.doWordContainOnlyEscapedSpace(rest)) {
            if (cursor > 1 && text.charAt(cursor) == ' ' && text.charAt(cursor - 1) == ' ') {
                return "";
            }
            return Parser.switchEscapedSpacesToSpacesInWord(rest);
        }
        if (cursor > 1 && text.charAt(cursor) == ' ' && text.charAt(cursor - 1) == ' ') {
            return "";
        }
        if (rest.trim().contains(SPACE)) {
            return rest.substring(rest.trim().lastIndexOf(SPACE)).trim();
        }
        return rest.trim();
    }

    public static String findEscapedSpaceWordCloseToEnd(String text) {
        int index;
        String originalText = text;
        while ((index = text.lastIndexOf(SPACE)) > -1) {
            if (index > 0 && text.charAt(index - 1) == '\\') {
                text = text.substring(0, index - 1);
                continue;
            }
            return originalText.substring(index + 1);
        }
        return originalText;
    }

    public static List<String> findAllWords(String text) {
        if (!Parser.doWordContainEscapedSpace(text)) {
            return Arrays.asList(text.trim().split(SPACE));
        }
        ArrayList<String> textList = new ArrayList<String>();
        Matcher matcher = spacePattern.matcher(text);
        while (matcher.find()) {
            if (matcher.start() > 0) {
                if (text.charAt(matcher.start() - 1) == '\\') {
                    if (matcher.end() + 1 >= text.length() || text.charAt(matcher.end()) != ' ') continue;
                    text = text.substring(matcher.end() + 1);
                    matcher = spacePattern.matcher(text);
                    continue;
                }
                textList.add(text.substring(0, matcher.start()));
                text = text.substring(matcher.end());
                matcher = spacePattern.matcher(text);
                continue;
            }
            text = text.substring(1);
            matcher = spacePattern.matcher(text);
        }
        if (text.length() > 0) {
            textList.add(text);
        }
        return textList;
    }

    public static boolean doWordContainOnlyEscapedSpace(String word) {
        return Parser.findAllOccurrences(word, spaceEscapedMatcher) == Parser.findAllOccurrences(word, SPACE);
    }

    public static boolean doWordContainEscapedSpace(String word) {
        return spaceEscapedPattern.matcher(word).find();
    }

    public static int findAllOccurrences(String word, String pattern) {
        int count = 0;
        while (word.contains(pattern)) {
            ++count;
            word = word.substring(word.indexOf(pattern) + pattern.length());
        }
        return count;
    }

    public static List<String> switchEscapedSpacesToSpacesInList(List<String> list) {
        ArrayList<String> newList = new ArrayList<String>(list.size());
        for (String s : list) {
            newList.add(Parser.switchEscapedSpacesToSpacesInWord(s));
        }
        return newList;
    }

    public static String switchSpacesToEscapedSpacesInWord(String word) {
        return spacePattern.matcher(word).replaceAll("\\\\ ");
    }

    public static String switchEscapedSpacesToSpacesInWord(String word) {
        return spaceEscapedPattern.matcher(word).replaceAll(SPACE);
    }

    public static String trim(String buffer) {
        int i;
        int count = 0;
        for (i = 0; i < buffer.length() && buffer.charAt(i) == ' '; ++i) {
            ++count;
        }
        if (count > 0) {
            buffer = buffer.substring(count);
        }
        count = buffer.length();
        for (i = buffer.length() - 1; i > 0 && buffer.charAt(i) == ' ' && buffer.charAt(i - 1) != '\\'; --i) {
            --count;
        }
        if (count != buffer.length()) {
            buffer = buffer.substring(0, count);
        }
        return buffer;
    }

    public static String findFirstWord(String buffer) {
        if (buffer.indexOf(32) < 0) {
            return buffer;
        }
        int index = (buffer = Parser.trim(buffer)).indexOf(32);
        if (index > 0) {
            return buffer.substring(0, index);
        }
        return buffer;
    }
}

