/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.ConnectorAdd;
import org.jboss.as.remoting.ConnectorRemove;
import org.jboss.as.remoting.NamedValueAttributeDefinition;
import org.jboss.as.remoting.RemotingExtension;
import org.jboss.as.remoting.RemotingMessages;
import org.jboss.as.remoting.SecurityActions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Property;
import org.xnio.Sequence;
import org.xnio.sasl.SaslQop;
import org.xnio.sasl.SaslStrength;

public class ConnectorResource
extends SimpleResourceDefinition {
    static final ConnectorResource INSTANCE = new ConnectorResource();
    static final SimpleAttributeDefinition AUTHENTICATION_PROVIDER = new NamedValueAttributeDefinition("authentication-provider", Attribute.NAME, null, ModelType.STRING, true);
    static final SimpleAttributeDefinition SOCKET_BINDING = new SimpleAttributeDefinition("socket-binding", ModelType.STRING, false);
    static final SimpleAttributeDefinition SECURITY_REALM = new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false)).build();

    private ConnectorResource() {
        super(PathElement.pathElement((String)"connector"), RemotingExtension.getResourceDescriptionResolver("connector"), (AbstractAddStepHandler)ConnectorAdd.INSTANCE, (OperationStepHandler)ConnectorRemove.INSTANCE);
    }

    protected static OptionMap getFullOptions(ModelNode fullModel) {
        ModelNode security;
        OptionMap.Builder builder = OptionMap.builder();
        ModelNode properties = fullModel.get("property");
        if (properties.isDefined() && properties.asInt() > 0) {
            ConnectorResource.addOptions(properties, builder);
        }
        if (fullModel.hasDefined("security") && (security = fullModel.require("security")).hasDefined("sasl")) {
            ModelNode sasl = security.require("sasl");
            ConnectorResource.addSasl(sasl, builder);
        }
        return builder.getMap();
    }

    protected static OptionMap getOptions(ModelNode properties) {
        if (properties.isDefined() && properties.asInt() > 0) {
            OptionMap.Builder builder = OptionMap.builder();
            ConnectorResource.addOptions(properties, builder);
            return builder.getMap();
        }
        return OptionMap.EMPTY;
    }

    private static void addSasl(ModelNode sasl, OptionMap.Builder builder) {
        ModelNode saslPolicy;
        if (sasl.hasDefined("include-mechanisms")) {
            builder.set(Options.SASL_MECHANISMS, (Object)Sequence.of(ConnectorResource.asStringSet(sasl.get("include-mechanisms"))));
        }
        if (sasl.hasDefined("qop")) {
            builder.set(Options.SASL_QOP, (Object)Sequence.of(ConnectorResource.asQopSet(sasl.get("qop"))));
        }
        if (sasl.hasDefined("strength")) {
            ModelNode strength = sasl.get("strength");
            for (ModelNode current : strength.asList()) {
                builder.set(Options.SASL_STRENGTH, (Object)ConnectorResource.strengthFromString(current.asString()));
            }
        }
        if (sasl.hasDefined("server-auth")) {
            builder.set(Options.SASL_SERVER_AUTH, sasl.get("server-auth").asBoolean());
        }
        if (sasl.hasDefined("reuse-session")) {
            builder.set(Options.SASL_REUSE, sasl.get("reuse-session").asBoolean());
        }
        if (sasl.hasDefined("sasl-policy") && (saslPolicy = sasl.get("sasl-policy")).hasDefined("policy")) {
            ModelNode policy = saslPolicy.get("policy");
            if (policy.hasDefined("forward-secrecy")) {
                builder.set(Options.SASL_POLICY_FORWARD_SECRECY, policy.get("forward-secrecy").asBoolean());
            }
            if (policy.hasDefined("no-active")) {
                builder.set(Options.SASL_POLICY_NOACTIVE, policy.get("no-active").asBoolean());
            }
            if (policy.hasDefined("no-anonymous")) {
                builder.set(Options.SASL_POLICY_NOANONYMOUS, policy.get("no-anonymous").asBoolean());
            }
            if (policy.hasDefined("no-dictionary")) {
                builder.set(Options.SASL_POLICY_NODICTIONARY, policy.get("no-dictionary").asBoolean());
            }
            if (policy.hasDefined("no-plain-text")) {
                builder.set(Options.SASL_POLICY_NOPLAINTEXT, policy.get("no-plain-text").asBoolean());
            }
            if (policy.hasDefined("pass-credentials")) {
                builder.set(Options.SASL_POLICY_PASS_CREDENTIALS, policy.get("pass-credentials").asBoolean());
            }
        }
        if (sasl.hasDefined("property")) {
            ModelNode property = sasl.get("property");
            List props = property.asPropertyList();
            ArrayList<Property> converted = new ArrayList<Property>(props.size());
            for (org.jboss.dmr.Property current : props) {
                converted.add(Property.of((String)current.getName(), (String)current.getValue().asString()));
            }
            builder.set(Options.SASL_PROPERTIES, (Object)Sequence.of(converted));
        }
    }

    private static void addOptions(ModelNode properties, OptionMap.Builder builder) {
        ClassLoader loader = SecurityActions.getClassLoader(ConnectorResource.class);
        for (org.jboss.dmr.Property property : properties.asPropertyList()) {
            String name = property.getName();
            if (!name.contains(".")) {
                name = "org.xnio.Options." + name;
            }
            Option option = Option.fromString((String)name, (ClassLoader)loader);
            builder.set(option, option.parseValue(property.getValue().get("value").asString(), loader));
        }
    }

    private static Collection<String> asStringSet(ModelNode node) {
        HashSet<String> set = new HashSet<String>();
        for (ModelNode element : node.asList()) {
            set.add(element.asString());
        }
        return set;
    }

    private static Collection<SaslQop> asQopSet(ModelNode node) {
        HashSet<SaslQop> set = new HashSet<SaslQop>();
        for (ModelNode element : node.asList()) {
            set.add(SaslQop.fromString((String)element.asString()));
        }
        return set;
    }

    private static SaslStrength strengthFromString(String name) {
        if ("low".equals(name)) {
            return SaslStrength.LOW;
        }
        if ("medium".equals(name)) {
            return SaslStrength.MEDIUM;
        }
        if ("high".equals(name)) {
            return SaslStrength.HIGH;
        }
        throw RemotingMessages.MESSAGES.illegalStrength(name);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{AUTHENTICATION_PROVIDER, SOCKET_BINDING, SECURITY_REALM});
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)AUTHENTICATION_PROVIDER, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SOCKET_BINDING, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SECURITY_REALM, null, (OperationStepHandler)writeHandler);
    }
}

