/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.web.WebConnectorAdd;
import org.jboss.as.web.WebConnectorMetrics;
import org.jboss.as.web.WebConnectorRemove;
import org.jboss.as.web.WebExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class WebConnectorDefinition
extends SimpleResourceDefinition {
    protected static final WebConnectorDefinition INSTANCE = new WebConnectorDefinition();
    protected static final SimpleAttributeDefinition NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).setXmlName("name").setAllowNull(true).build();
    protected static final SimpleAttributeDefinition PROTOCOL = new SimpleAttributeDefinitionBuilder("protocol", ModelType.STRING).setXmlName("protocol").setAllowNull(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1)).build();
    protected static final SimpleAttributeDefinition SOCKET_BINDING = new SimpleAttributeDefinitionBuilder("socket-binding", ModelType.STRING).setXmlName("socket-binding").setAllowNull(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1)).build();
    protected static final SimpleAttributeDefinition SCHEME = new SimpleAttributeDefinitionBuilder("scheme", ModelType.STRING).setXmlName("scheme").setAllowNull(false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1)).build();
    protected static final SimpleAttributeDefinition EXECUTOR = new SimpleAttributeDefinitionBuilder("executor", ModelType.STRING).setXmlName("executor").setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1, true)).build();
    protected static final SimpleAttributeDefinition ENABLED = new SimpleAttributeDefinitionBuilder("enabled", ModelType.BOOLEAN).setXmlName("enabled").setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(true)).build();
    protected static final SimpleAttributeDefinition ENABLE_LOOKUPS = new SimpleAttributeDefinitionBuilder("enable-lookups", ModelType.BOOLEAN).setXmlName("enable-lookups").setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(false)).build();
    protected static final SimpleAttributeDefinition PROXY_NAME = new SimpleAttributeDefinitionBuilder("proxy-name", ModelType.STRING).setXmlName("proxy-name").setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new StringLengthValidator(1, true)).build();
    protected static final SimpleAttributeDefinition PROXY_PORT = new SimpleAttributeDefinitionBuilder("proxy-port", ModelType.INT).setXmlName("proxy-port").setAllowNull(true).setValidator((ParameterValidator)new IntRangeValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition MAX_POST_SIZE = new SimpleAttributeDefinitionBuilder("max-post-size", ModelType.INT).setXmlName("max-post-size").setAllowNull(true).setValidator((ParameterValidator)new IntRangeValidator(0, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(0x200000)).build();
    protected static final SimpleAttributeDefinition MAX_SAVE_POST_SIZE = new SimpleAttributeDefinitionBuilder("max-save-post-size", ModelType.INT).setXmlName("max-save-post-size").setAllowNull(true).setValidator((ParameterValidator)new IntRangeValidator(0, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(4096)).build();
    protected static final SimpleAttributeDefinition SECURE = new SimpleAttributeDefinitionBuilder("secure", ModelType.BOOLEAN).setXmlName("secure").setAllowNull(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(false)).build();
    protected static final SimpleAttributeDefinition REDIRECT_PORT = new SimpleAttributeDefinitionBuilder("redirect-port", ModelType.INT).setXmlName("redirect-port").setAllowNull(true).setValidator((ParameterValidator)new IntRangeValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode(8433)).build();
    protected static final SimpleAttributeDefinition MAX_CONNECTIONS = new SimpleAttributeDefinitionBuilder("max-connections", ModelType.INT).setXmlName("max-connections").setAllowNull(true).setValidator((ParameterValidator)new IntRangeValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleListAttributeDefinition VIRTUAL_SERVER = SimpleListAttributeDefinition.Builder.of((String)"virtual-server", (SimpleAttributeDefinition)new SimpleAttributeDefinitionBuilder("virtual-server", ModelType.STRING, false).setXmlName("virtual-server").setAllowNull(false).setValidator((ParameterValidator)new StringLengthValidator(1, false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}).build()).setAllowNull(true).build();
    protected static final SimpleAttributeDefinition[] CONNECTOR_ATTRIBUTES = new SimpleAttributeDefinition[]{PROTOCOL, SCHEME, SOCKET_BINDING, ENABLE_LOOKUPS, PROXY_NAME, PROXY_PORT, REDIRECT_PORT, SECURE, MAX_POST_SIZE, MAX_SAVE_POST_SIZE, ENABLED, EXECUTOR, MAX_CONNECTIONS};

    private WebConnectorDefinition() {
        super(WebExtension.CONNECTOR_PATH, (ResourceDescriptionResolver)WebExtension.getResourceDescriptionResolver("connector"), (AbstractAddStepHandler)WebConnectorAdd.INSTANCE, (OperationStepHandler)WebConnectorRemove.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration connectors) {
        connectors.registerReadOnlyAttribute((AttributeDefinition)NAME, null);
        for (SimpleAttributeDefinition def : CONNECTOR_ATTRIBUTES) {
            connectors.registerReadWriteAttribute((AttributeDefinition)def, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{def}));
        }
        connectors.registerReadWriteAttribute((AttributeDefinition)VIRTUAL_SERVER, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{VIRTUAL_SERVER}));
        for (SimpleAttributeDefinition def : WebConnectorMetrics.ATTRIBUTES) {
            connectors.registerMetric((AttributeDefinition)def, (OperationStepHandler)WebConnectorMetrics.INSTANCE);
        }
    }
}

