/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.ArrayList;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.AbstractSubsystemTransformer;
import org.jboss.as.controller.transform.AliasOperationTransformer;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.as.web.DefaultJsfProfileCompletionHandler;
import org.jboss.as.web.Namespace;
import org.jboss.as.web.WebAccessLogDefinition;
import org.jboss.as.web.WebAccessLogDirectoryDefinition;
import org.jboss.as.web.WebConnectorDefinition;
import org.jboss.as.web.WebContainerDefinition;
import org.jboss.as.web.WebDefinition;
import org.jboss.as.web.WebDeploymentDefinition;
import org.jboss.as.web.WebDeploymentServletDefinition;
import org.jboss.as.web.WebJSPDefinition;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.WebReWriteConditionDefinition;
import org.jboss.as.web.WebReWriteDefinition;
import org.jboss.as.web.WebSSLDefinition;
import org.jboss.as.web.WebSSODefinition;
import org.jboss.as.web.WebStaticResources;
import org.jboss.as.web.WebSubsystemParser;
import org.jboss.as.web.WebVirtualHostDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class WebExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "web";
    public static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"web");
    protected static final PathElement CONNECTOR_PATH = PathElement.pathElement((String)"connector");
    protected static final PathElement SSL_PATH = PathElement.pathElement((String)"configuration", (String)"ssl");
    protected static final PathElement SSL_ALIAS = PathElement.pathElement((String)"ssl", (String)"configuration");
    protected static final PathElement HOST_PATH = PathElement.pathElement((String)"virtual-server");
    protected static final PathElement JSP_CONFIGURATION_PATH = PathElement.pathElement((String)"configuration", (String)"jsp-configuration");
    protected static final PathElement STATIC_RESOURCES_PATH = PathElement.pathElement((String)"configuration", (String)"static-resources");
    protected static final PathElement CONTAINER_PATH = PathElement.pathElement((String)"configuration", (String)"container");
    protected static final PathElement ACCESS_LOG_PATH = PathElement.pathElement((String)"configuration", (String)"access-log");
    protected static final PathElement ACCESS_LOG_ALIAS = PathElement.pathElement((String)"access-log", (String)"configuration");
    protected static final PathElement REWRITE_PATH = PathElement.pathElement((String)"rewrite");
    protected static final PathElement SSO_PATH = PathElement.pathElement((String)"configuration", (String)"sso");
    protected static final PathElement SSO_ALIAS = PathElement.pathElement((String)"sso", (String)"configuration");
    protected static final PathElement DIRECTORY_PATH = PathElement.pathElement((String)"setting", (String)"directory");
    protected static final PathElement DIRECTORY_ALIAS = PathElement.pathElement((String)"directory", (String)"configuration");
    protected static final PathElement REWRITECOND_PATH = PathElement.pathElement((String)"condition");
    private static final String RESOURCE_NAME = WebExtension.class.getPackage().getName() + ".LocalDescriptions";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        String prefix = SUBSYSTEM_NAME + (keyPrefix == null ? "" : "." + keyPrefix);
        return new StandardResourceDescriptionResolver(prefix, RESOURCE_NAME, WebExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2, 0);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)WebDefinition.INSTANCE);
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        subsystem.registerXMLElementWriter((XMLElementWriter)WebSubsystemParser.getInstance());
        ManagementResourceRegistration connectors = registration.registerSubModel((ResourceDefinition)WebConnectorDefinition.INSTANCE);
        ManagementResourceRegistration ssl = connectors.registerSubModel((ResourceDefinition)WebSSLDefinition.INSTANCE);
        connectors.registerAlias(SSL_ALIAS, (AliasEntry)new StandardWebExtensionAliasEntry(ssl));
        ManagementResourceRegistration hosts = registration.registerSubModel((ResourceDefinition)WebVirtualHostDefinition.INSTANCE);
        ManagementResourceRegistration accesslog = hosts.registerSubModel((ResourceDefinition)WebAccessLogDefinition.INSTANCE);
        hosts.registerAlias(ACCESS_LOG_ALIAS, (AliasEntry)new StandardWebExtensionAliasEntry(accesslog));
        ManagementResourceRegistration accessLogDir = accesslog.registerSubModel((ResourceDefinition)WebAccessLogDirectoryDefinition.INSTANCE);
        accesslog.registerAlias(DIRECTORY_ALIAS, (AliasEntry)new StandardWebExtensionAliasEntry(accessLogDir));
        ManagementResourceRegistration sso = hosts.registerSubModel((ResourceDefinition)WebSSODefinition.INSTANCE);
        hosts.registerAlias(SSO_ALIAS, (AliasEntry)new StandardWebExtensionAliasEntry(sso));
        ManagementResourceRegistration rewrite = hosts.registerSubModel((ResourceDefinition)WebReWriteDefinition.INSTANCE);
        rewrite.registerSubModel((ResourceDefinition)WebReWriteConditionDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)WebJSPDefinition.INSTANCE);
        registration.registerSubModel((ResourceDefinition)WebStaticResources.INSTANCE);
        registration.registerSubModel((ResourceDefinition)WebContainerDefinition.INSTANCE);
        ManagementResourceRegistration deployments = subsystem.registerDeploymentModel((ResourceDefinition)WebDeploymentDefinition.INSTANCE);
        deployments.registerSubModel((ResourceDefinition)WebDeploymentServletDefinition.INSTANCE);
        this.registerTransformers_1_1_0(subsystem);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.WEB_1_2.getUriString(), (XMLElementReader)WebSubsystemParser.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.WEB_1_1.getUriString(), (XMLElementReader)WebSubsystemParser.getInstance());
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, Namespace.WEB_1_0.getUriString(), (XMLElementReader)WebSubsystemParser.getInstance());
        context.setProfileParsingCompletionHandler((ProfileParsingCompletionHandler)new DefaultJsfProfileCompletionHandler());
    }

    private void registerTransformers_1_1_0(SubsystemRegistration registration) {
        TransformersSubRegistration transformers = registration.registerModelTransformers((ModelVersionRange)ModelVersion.create((int)1, (int)1, (int)0), (ResourceTransformer)new AbstractSubsystemTransformer(SUBSYSTEM_NAME){

            protected ModelNode transformModel(TransformationContext context, ModelNode model) {
                if (model.hasDefined("connector")) {
                    for (String name : model.get("connector").keys()) {
                        this.swap(model.get(new String[]{"connector", name}), SSL_PATH, SSL_ALIAS);
                    }
                }
                if (model.hasDefined("virtual-server")) {
                    for (String name : model.get("virtual-server").keys()) {
                        ModelNode virtualServer = model.get(new String[]{"virtual-server", name});
                        this.swap(virtualServer, SSO_PATH, SSO_ALIAS);
                        this.swap(virtualServer, ACCESS_LOG_PATH, ACCESS_LOG_ALIAS);
                        ModelNode accessLog = virtualServer.get(new String[]{ACCESS_LOG_ALIAS.getKey(), ACCESS_LOG_ALIAS.getValue()});
                        this.swap(accessLog, DIRECTORY_PATH, DIRECTORY_ALIAS);
                    }
                }
                return model;
            }

            private void swap(ModelNode parent, PathElement original, PathElement old) {
                if (parent.hasDefined(original.getKey()) && parent.get(original.getKey()).hasDefined(original.getValue())) {
                    ModelNode sslConfig = parent.get(new String[]{original.getKey(), original.getValue()});
                    parent.get(new String[]{old.getKey(), old.getValue()}).set(sslConfig.clone());
                    parent.get(original.getKey()).remove(original.getValue());
                    if (parent.get(original.getKey()).asList().isEmpty()) {
                        parent.remove(original.getKey());
                    }
                }
            }
        });
        TransformersSubRegistration connectors = transformers.registerSubResource(CONNECTOR_PATH);
        connectors.registerOperationTransformer("add", new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                final boolean hasDefinedVirtualServer = operation.hasDefined("virtual-server");
                return new OperationTransformer.TransformedOperation(operation, new OperationResultTransformer(){

                    public ModelNode transformResult(ModelNode result) {
                        if (!hasDefinedVirtualServer) {
                            return result;
                        }
                        if (result.get("outcome").asString().equals("failed")) {
                            result.get("failure-description").set(WebMessages.MESSAGES.transformationVersion_1_1_0_JBPAPP_9314());
                        }
                        return result;
                    }
                });
            }
        });
        connectors.registerOperationTransformer("write-attribute", new OperationTransformer(){

            public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
                final boolean isVirtualServer = operation.get("name").asString().equals("virtual-server");
                return new OperationTransformer.TransformedOperation(operation, new OperationResultTransformer(){

                    public ModelNode transformResult(ModelNode result) {
                        if (!isVirtualServer) {
                            return result;
                        }
                        if (result.get("outcome").asString().equals("failed")) {
                            result.get("failure-description").set(WebMessages.MESSAGES.transformationVersion_1_1_0_JBPAPP_9314());
                        }
                        return result;
                    }
                });
            }
        });
        TransformersSubRegistration ssl = connectors.registerSubResource(SSL_PATH, (OperationTransformer)AliasOperationTransformer.replaceLastElement((PathElement)SSL_ALIAS));
        TransformersSubRegistration virtualServer = transformers.registerSubResource(HOST_PATH);
        TransformersSubRegistration sso = virtualServer.registerSubResource(SSO_PATH, (OperationTransformer)AliasOperationTransformer.replaceLastElement((PathElement)SSO_ALIAS));
        TransformersSubRegistration accessLog = virtualServer.registerSubResource(ACCESS_LOG_PATH, (OperationTransformer)AliasOperationTransformer.replaceLastElement((PathElement)ACCESS_LOG_ALIAS));
        TransformersSubRegistration accessLogDir = accessLog.registerSubResource(DIRECTORY_PATH, (OperationTransformer)AliasOperationTransformer.create((AliasOperationTransformer.AddressTransformer)new AliasOperationTransformer.AddressTransformer(){

            public PathAddress transformAddress(PathAddress address) {
                PathAddress copy = PathAddress.EMPTY_ADDRESS;
                for (PathElement element : address) {
                    if (element.getKey().equals("configuration")) {
                        copy = copy.append(new PathElement[]{ACCESS_LOG_ALIAS});
                        continue;
                    }
                    if (element.getKey().equals("setting")) {
                        copy = copy.append(new PathElement[]{DIRECTORY_ALIAS});
                        continue;
                    }
                    copy = copy.append(new PathElement[]{element});
                }
                return copy;
            }
        }));
    }

    private static class StandardWebExtensionAliasEntry
    extends AliasEntry {
        public StandardWebExtensionAliasEntry(ManagementResourceRegistration target) {
            super(target);
        }

        public PathAddress convertToTargetAddress(PathAddress addr) {
            PathAddress targetAddress = this.getTargetAddress();
            ArrayList<PathElement> list = new ArrayList<PathElement>();
            int i = 0;
            for (PathElement element : addr) {
                String key = element.getKey();
                try {
                    if (i < targetAddress.size() && (key.equals("ssl") || key.equals("sso") || key.equals("access-log") || key.equals("directory"))) {
                        list.add(targetAddress.getElement(i));
                    } else {
                        list.add(element);
                    }
                    ++i;
                }
                catch (Exception e) {
                    throw new RuntimeException("Bad " + addr + " " + targetAddress);
                }
            }
            return PathAddress.pathAddress(list);
        }
    }
}

