/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import javax.el.BeanELResolver;
import javax.el.ExpressionFactory;
import org.apache.el.ExpressionFactoryImpl;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.as.web.WebLogger;
import org.jboss.el.cache.FactoryFinderCache;
import org.jboss.modules.Module;

public class ELExpressionFactoryProcessor
implements DeploymentUnitProcessor {
    public static final String FACTORY_ID = ExpressionFactory.class.getName();
    private static final Method purge;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            return;
        }
        ServicesAttachment services = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        List implementations = services.getServiceImplementations(ExpressionFactory.class.getName());
        if (implementations != null && implementations.size() > 0) {
            FactoryFinderCache.addCacheEntry((ClassLoader)module.getClassLoader(), (String)FACTORY_ID, (String)((String)implementations.get(0)));
        }
        try {
            String javah = System.getProperty("java.home");
            String configFile = javah + File.separator + "lib" + File.separator + "el.properties";
            File f = new File(configFile);
            if (f.exists()) {
                Properties props = new Properties();
                props.load(new FileInputStream(f));
                String factoryClassName = props.getProperty(FACTORY_ID);
                FactoryFinderCache.addCacheEntry((ClassLoader)module.getClassLoader(), (String)FACTORY_ID, (String)factoryClassName);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            String systemProp = System.getProperty(FACTORY_ID);
            if (systemProp != null) {
                FactoryFinderCache.addCacheEntry((ClassLoader)module.getClassLoader(), (String)FACTORY_ID, (String)systemProp);
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        FactoryFinderCache.addCacheEntry((ClassLoader)module.getClassLoader(), (String)FACTORY_ID, (String)ExpressionFactoryImpl.class.getName());
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module != null) {
            FactoryFinderCache.clearClassLoader((ClassLoader)module.getClassLoader());
            try {
                purge.invoke((Object)new BeanELResolver(), module.getClassLoader());
            }
            catch (Exception e) {
                WebLogger.ROOT_LOGGER.couldNotPurgeELCache(e);
            }
        }
    }

    static {
        try {
            purge = BeanELResolver.class.getDeclaredMethod("purgeBeanClasses", ClassLoader.class);
            purge.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

