/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletContext;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.ThreadBindingListener;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.web.ThreadSetupBindingListener;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.deployment.ServletContextAttribute;
import org.jboss.as.web.deployment.WebInjectionContainer;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class WebDeploymentService
implements Service<StandardContext> {
    private final StandardContext context;
    private final InjectedValue<Realm> realm = new InjectedValue();
    private final WebInjectionContainer injectionContainer;
    private final List<SetupAction> setupActions;
    final List<ServletContextAttribute> attributes;

    public WebDeploymentService(StandardContext context, WebInjectionContainer injectionContainer, List<SetupAction> setupActions, List<ServletContextAttribute> attributes) {
        this.context = context;
        this.injectionContainer = injectionContainer;
        this.setupActions = setupActions;
        this.attributes = attributes;
    }

    InjectedValue<Realm> getRealm() {
        return this.realm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext startContext) throws StartException {
        if (this.attributes != null) {
            ServletContext context = this.context.getServletContext();
            for (ServletContextAttribute attribute : this.attributes) {
                context.setAttribute(attribute.getName(), attribute.getValue());
            }
        }
        this.context.setRealm((Realm)this.realm.getValue());
        WebInjectionContainer.setCurrentInjectionContainer(this.injectionContainer);
        ArrayList<SetupAction> actions = new ArrayList<SetupAction>();
        actions.addAll(this.setupActions);
        this.context.setInstanceManager((InstanceManager)this.injectionContainer);
        this.context.setThreadBindingListener((ThreadBindingListener)new ThreadSetupBindingListener(actions));
        WebLogger.WEB_LOGGER.registerWebapp(this.context.getName());
        try {
            try {
                this.context.create();
            }
            catch (Exception e) {
                throw new StartException(WebMessages.MESSAGES.createContextFailed(), (Throwable)e);
            }
            try {
                this.context.start();
            }
            catch (LifecycleException e) {
                throw new StartException(WebMessages.MESSAGES.startContextFailed(), (Throwable)e);
            }
            if (this.context.getState() != 1) {
                throw new StartException(WebMessages.MESSAGES.startContextFailed());
            }
        }
        finally {
            WebInjectionContainer.setCurrentInjectionContainer(null);
        }
    }

    public synchronized void stop(StopContext stopContext) {
        WebLogger.WEB_LOGGER.unregisterWebapp(this.context.getName());
        try {
            this.context.stop();
        }
        catch (LifecycleException e) {
            WebLogger.WEB_LOGGER.stopContextFailed(e);
        }
        try {
            this.context.destroy();
        }
        catch (Exception e) {
            WebLogger.WEB_LOGGER.destroyContextFailed(e);
        }
    }

    public synchronized StandardContext getValue() throws IllegalStateException {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return this.context;
    }

    public static class ContextActivator {
        public static final AttachmentKey<ContextActivator> ATTACHMENT_KEY = AttachmentKey.create(ContextActivator.class);
        private final ServiceController<StandardContext> controller;

        ContextActivator(ServiceController<StandardContext> controller) {
            this.controller = controller;
        }

        public StandardContext getContext() {
            return (StandardContext)this.controller.getValue();
        }

        public synchronized void startAsync() {
            this.controller.setMode(ServiceController.Mode.ACTIVE);
        }

        public synchronized boolean start(long timeout, TimeUnit unit) throws TimeoutException {
            boolean result = true;
            if (this.controller.getMode() == ServiceController.Mode.NEVER) {
                this.controller.setMode(ServiceController.Mode.ACTIVE);
                result = this.awaitStateChange(ServiceController.State.UP, timeout, unit);
            }
            return result;
        }

        public synchronized boolean stop(long timeout, TimeUnit unit) {
            boolean result = true;
            if (this.controller.getMode() == ServiceController.Mode.ACTIVE) {
                this.controller.setMode(ServiceController.Mode.NEVER);
                try {
                    result = this.awaitStateChange(ServiceController.State.DOWN, timeout, unit);
                }
                catch (TimeoutException ex) {
                    WebLogger.WEB_LOGGER.debugf("Timeout stopping context: %s", this.controller.getName());
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean awaitStateChange(final ServiceController.State expectedState, long timeout, TimeUnit unit) throws TimeoutException {
            final CountDownLatch latch = new CountDownLatch(1);
            AbstractServiceListener<StandardContext> listener = new AbstractServiceListener<StandardContext>(){

                public void listenerAdded(ServiceController<? extends StandardContext> controller) {
                    ServiceController.State state = controller.getState();
                    if (state == expectedState || state == ServiceController.State.START_FAILED) {
                        this.listenerDone(controller);
                    }
                }

                public void transition(ServiceController<? extends StandardContext> controller, ServiceController.Transition transition) {
                    if (expectedState == ServiceController.State.UP) {
                        switch (transition) {
                            case STARTING_to_UP: 
                            case STARTING_to_START_FAILED: {
                                this.listenerDone(controller);
                            }
                        }
                    } else if (expectedState == ServiceController.State.DOWN) {
                        switch (transition) {
                            case STOPPING_to_DOWN: 
                            case REMOVING_to_DOWN: 
                            case WAITING_to_DOWN: {
                                this.listenerDone(controller);
                            }
                        }
                    }
                }

                private void listenerDone(ServiceController<? extends StandardContext> controller) {
                    latch.countDown();
                }
            };
            this.controller.addListener((ServiceListener)listener);
            try {
                if (!latch.await(timeout, unit)) {
                    throw WebMessages.MESSAGES.timeoutContextActivation(this.controller.getName());
                }
            }
            catch (InterruptedException e) {
            }
            finally {
                this.controller.removeListener((ServiceListener)listener);
            }
            return this.controller.getState() == expectedState;
        }
    }
}

