/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml;

import io.milvus.exception.ParamException;
import io.milvus.grpc.PlaceholderType;
import io.milvus.param.MetricType;
import io.milvus.param.ParamUtils;
import io.milvus.param.dml.SearchParam;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.SortedMap;
import lombok.NonNull;

public class AnnSearchParam {
    private final String metricType;
    private final String vectorFieldName;
    private final int topK;
    private final String expr;
    private final List<?> vectors;
    private final Long NQ;
    private final String params;
    private final PlaceholderType plType;

    private AnnSearchParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.metricType = builder.metricType.name();
        this.vectorFieldName = builder.vectorFieldName;
        this.topK = builder.topK;
        this.expr = builder.expr;
        this.vectors = builder.vectors;
        this.NQ = builder.NQ;
        this.params = builder.params;
        this.plType = builder.plType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "AnnSearchParam{metricType=" + this.metricType + ", vectorFieldName='" + this.vectorFieldName + '\'' + ", expr='" + this.expr + '\'' + ", topK=" + this.topK + ", nq=" + this.NQ + ", expr='" + this.expr + '\'' + ", params='" + this.params + '\'' + '}';
    }

    public String getMetricType() {
        return this.metricType;
    }

    public String getVectorFieldName() {
        return this.vectorFieldName;
    }

    public int getTopK() {
        return this.topK;
    }

    public String getExpr() {
        return this.expr;
    }

    public List<?> getVectors() {
        return this.vectors;
    }

    public Long getNQ() {
        return this.NQ;
    }

    public String getParams() {
        return this.params;
    }

    public PlaceholderType getPlType() {
        return this.plType;
    }

    public static class Builder {
        private MetricType metricType = MetricType.None;
        private String vectorFieldName;
        private Integer topK;
        private String expr = "";
        private List<?> vectors;
        private Long NQ;
        private String params = "{}";
        private PlaceholderType plType = PlaceholderType.None;

        Builder() {
        }

        public Builder withMetricType(@NonNull MetricType metricType) {
            if (metricType == null) {
                throw new NullPointerException("metricType is marked non-null but is null");
            }
            this.metricType = metricType;
            return this;
        }

        public Builder withVectorFieldName(@NonNull String vectorFieldName) {
            if (vectorFieldName == null) {
                throw new NullPointerException("vectorFieldName is marked non-null but is null");
            }
            this.vectorFieldName = vectorFieldName;
            return this;
        }

        public Builder withTopK(@NonNull Integer topK) {
            if (topK == null) {
                throw new NullPointerException("topK is marked non-null but is null");
            }
            this.topK = topK;
            return this;
        }

        public Builder withExpr(@NonNull String expr) {
            if (expr == null) {
                throw new NullPointerException("expr is marked non-null but is null");
            }
            this.expr = expr;
            return this;
        }

        public Builder withFloatVectors(@NonNull List<List<Float>> vectors) {
            if (vectors == null) {
                throw new NullPointerException("vectors is marked non-null but is null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.FloatVector;
            return this;
        }

        public Builder withBinaryVectors(@NonNull List<ByteBuffer> vectors) {
            if (vectors == null) {
                throw new NullPointerException("vectors is marked non-null but is null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.BinaryVector;
            return this;
        }

        public Builder withFloat16Vectors(@NonNull List<ByteBuffer> vectors) {
            if (vectors == null) {
                throw new NullPointerException("vectors is marked non-null but is null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.Float16Vector;
            return this;
        }

        public Builder withBFloat16Vectors(@NonNull List<ByteBuffer> vectors) {
            if (vectors == null) {
                throw new NullPointerException("vectors is marked non-null but is null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.BFloat16Vector;
            return this;
        }

        public Builder withSparseFloatVectors(@NonNull List<SortedMap<Long, Float>> vectors) {
            if (vectors == null) {
                throw new NullPointerException("vectors is marked non-null but is null");
            }
            this.vectors = vectors;
            this.NQ = vectors.size();
            this.plType = PlaceholderType.SparseFloatVector;
            return this;
        }

        public Builder withParams(@NonNull String params) {
            if (params == null) {
                throw new NullPointerException("params is marked non-null but is null");
            }
            this.params = params;
            return this;
        }

        public AnnSearchParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.vectorFieldName, "Target field name");
            if (this.topK <= 0) {
                throw new ParamException("TopK value is illegal");
            }
            if (this.vectors.isEmpty()) {
                throw new ParamException("At lease a vector is required for AnnSearchParam");
            }
            SearchParam.verifyVectors(this.vectors);
            return new AnnSearchParam(this);
        }
    }
}

