/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone.unsigned_indices_model;

import io.pinecone.proto.QueryResponse;
import io.pinecone.proto.ScoredVector;
import io.pinecone.proto.Usage;
import io.pinecone.unsigned_indices_model.ScoredVectorWithUnsignedIndices;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QueryResponseWithUnsignedIndices {
    private List<ScoredVectorWithUnsignedIndices> matches;
    private String namespace;
    private Usage usage;

    public QueryResponseWithUnsignedIndices(QueryResponse queryResponse) {
        if (queryResponse == null) {
            this.matches = Collections.emptyList();
            this.namespace = "";
            this.usage = null;
        } else {
            this.matches = this.convertToScoredVectorWithUnsignedIndices(queryResponse.getMatchesList());
            this.namespace = queryResponse.getNamespace();
            this.usage = queryResponse.getUsage();
        }
    }

    public List<ScoredVectorWithUnsignedIndices> getMatchesList() {
        return this.matches;
    }

    public ScoredVectorWithUnsignedIndices getMatches(int index) {
        return this.matches.get(index);
    }

    public List<ScoredVectorWithUnsignedIndices> convertToScoredVectorWithUnsignedIndices(List<ScoredVector> matches) {
        if (matches == null) {
            throw new IllegalArgumentException("Matches list cannot be null.");
        }
        ArrayList<ScoredVectorWithUnsignedIndices> scoredVectorList = new ArrayList<ScoredVectorWithUnsignedIndices>(matches.size());
        for (ScoredVector scoredVector : matches) {
            scoredVectorList.add(new ScoredVectorWithUnsignedIndices(scoredVector));
        }
        return scoredVectorList;
    }

    public void setMatches(List<ScoredVectorWithUnsignedIndices> matches) {
        this.matches = matches;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public void setUsage(Usage usage) {
        this.usage = usage;
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryResponseWithUnsignedIndices {").append("\n");
        sb.append("    matches: ").append(this.toIndentedString(this.matches)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    usage: ").append(this.usage).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

