/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.db_control.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.db_control.client.JSON;
import org.openapitools.db_control.client.model.DeletionProtection;
import org.openapitools.db_control.client.model.IndexModelSpec;
import org.openapitools.db_control.client.model.IndexModelStatus;
import org.openapitools.db_control.client.model.ModelIndexEmbed;

public class IndexModel {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DIMENSION = "dimension";
    @SerializedName(value="dimension")
    private Integer dimension;
    public static final String SERIALIZED_NAME_METRIC = "metric";
    @SerializedName(value="metric")
    private MetricEnum metric;
    public static final String SERIALIZED_NAME_HOST = "host";
    @SerializedName(value="host")
    private String host;
    public static final String SERIALIZED_NAME_DELETION_PROTECTION = "deletion_protection";
    @SerializedName(value="deletion_protection")
    private DeletionProtection deletionProtection = DeletionProtection.DISABLED;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private Map<String, String> tags = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_EMBED = "embed";
    @SerializedName(value="embed")
    private ModelIndexEmbed embed;
    public static final String SERIALIZED_NAME_SPEC = "spec";
    @SerializedName(value="spec")
    private IndexModelSpec spec;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private IndexModelStatus status;
    public static final String SERIALIZED_NAME_VECTOR_TYPE = "vector_type";
    @SerializedName(value="vector_type")
    private String vectorType = "dense";
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public IndexModel name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IndexModel dimension(Integer dimension) {
        this.dimension = dimension;
        return this;
    }

    @Nullable
    public Integer getDimension() {
        return this.dimension;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public IndexModel metric(MetricEnum metric) {
        this.metric = metric;
        return this;
    }

    @Nonnull
    public MetricEnum getMetric() {
        return this.metric;
    }

    public void setMetric(MetricEnum metric) {
        this.metric = metric;
    }

    public IndexModel host(String host) {
        this.host = host;
        return this;
    }

    @Nonnull
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public IndexModel deletionProtection(DeletionProtection deletionProtection) {
        this.deletionProtection = deletionProtection;
        return this;
    }

    @Nullable
    public DeletionProtection getDeletionProtection() {
        return this.deletionProtection;
    }

    public void setDeletionProtection(DeletionProtection deletionProtection) {
        this.deletionProtection = deletionProtection;
    }

    public IndexModel tags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public IndexModel putTagsItem(String key, String tagsItem) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key, tagsItem);
        return this;
    }

    @Nullable
    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public IndexModel embed(ModelIndexEmbed embed) {
        this.embed = embed;
        return this;
    }

    @Nullable
    public ModelIndexEmbed getEmbed() {
        return this.embed;
    }

    public void setEmbed(ModelIndexEmbed embed) {
        this.embed = embed;
    }

    public IndexModel spec(IndexModelSpec spec) {
        this.spec = spec;
        return this;
    }

    @Nonnull
    public IndexModelSpec getSpec() {
        return this.spec;
    }

    public void setSpec(IndexModelSpec spec) {
        this.spec = spec;
    }

    public IndexModel status(IndexModelStatus status) {
        this.status = status;
        return this;
    }

    @Nonnull
    public IndexModelStatus getStatus() {
        return this.status;
    }

    public void setStatus(IndexModelStatus status) {
        this.status = status;
    }

    public IndexModel vectorType(String vectorType) {
        this.vectorType = vectorType;
        return this;
    }

    @Nonnull
    public String getVectorType() {
        return this.vectorType;
    }

    public void setVectorType(String vectorType) {
        this.vectorType = vectorType;
    }

    public IndexModel putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexModel indexModel = (IndexModel)o;
        return Objects.equals(this.name, indexModel.name) && Objects.equals(this.dimension, indexModel.dimension) && Objects.equals((Object)this.metric, (Object)indexModel.metric) && Objects.equals(this.host, indexModel.host) && Objects.equals((Object)this.deletionProtection, (Object)indexModel.deletionProtection) && Objects.equals(this.tags, indexModel.tags) && Objects.equals(this.embed, indexModel.embed) && Objects.equals(this.spec, indexModel.spec) && Objects.equals(this.status, indexModel.status) && Objects.equals(this.vectorType, indexModel.vectorType) && Objects.equals(this.additionalProperties, indexModel.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.dimension, this.metric, this.host, this.deletionProtection, this.tags, this.embed, this.spec, this.status, this.vectorType, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IndexModel {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dimension: ").append(this.toIndentedString(this.dimension)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString((Object)this.metric)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    deletionProtection: ").append(this.toIndentedString((Object)this.deletionProtection)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    embed: ").append(this.toIndentedString(this.embed)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    vectorType: ").append(this.toIndentedString(this.vectorType)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in IndexModel is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_METRIC).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `metric` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_METRIC).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_HOST).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `host` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOST).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EMBED) != null && !jsonObj.get(SERIALIZED_NAME_EMBED).isJsonNull()) {
            ModelIndexEmbed.validateJsonElement(jsonObj.get(SERIALIZED_NAME_EMBED));
        }
        IndexModelSpec.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SPEC));
        IndexModelStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        if (!jsonObj.get(SERIALIZED_NAME_VECTOR_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `vector_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VECTOR_TYPE).toString()));
        }
    }

    public static IndexModel fromJson(String jsonString) throws IOException {
        return (IndexModel)JSON.getGson().fromJson(jsonString, IndexModel.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_DIMENSION);
        openapiFields.add(SERIALIZED_NAME_METRIC);
        openapiFields.add(SERIALIZED_NAME_HOST);
        openapiFields.add(SERIALIZED_NAME_DELETION_PROTECTION);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiFields.add(SERIALIZED_NAME_EMBED);
        openapiFields.add(SERIALIZED_NAME_SPEC);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_VECTOR_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_METRIC);
        openapiRequiredFields.add(SERIALIZED_NAME_HOST);
        openapiRequiredFields.add(SERIALIZED_NAME_SPEC);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_VECTOR_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!IndexModel.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(IndexModel.class));
            return new TypeAdapter<IndexModel>(){

                public void write(JsonWriter out, IndexModel value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public IndexModel read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    IndexModel.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    IndexModel instance = (IndexModel)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MetricEnum {
        COSINE("cosine"),
        EUCLIDEAN("euclidean"),
        DOTPRODUCT("dotproduct");

        private String value;

        private MetricEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MetricEnum fromValue(String value) {
            for (MetricEnum b : MetricEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<MetricEnum> {
            public void write(JsonWriter jsonWriter, MetricEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MetricEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MetricEnum.fromValue(value);
            }
        }
    }
}

