/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.inference.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openapitools.inference.client.JSON;
import org.openapitools.inference.client.model.AbstractOpenApiSchema;
import org.openapitools.inference.client.model.DenseEmbedding;
import org.openapitools.inference.client.model.SparseEmbedding;

public class Embedding
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(Embedding.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();

    public Embedding() {
        super("oneOf", Boolean.FALSE);
    }

    public Embedding(DenseEmbedding o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public Embedding(SparseEmbedding o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof DenseEmbedding) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof SparseEmbedding) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be DenseEmbedding, SparseEmbedding");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public DenseEmbedding getDenseEmbedding() throws ClassCastException {
        return (DenseEmbedding)super.getActualInstance();
    }

    public SparseEmbedding getSparseEmbedding() throws ClassCastException {
        return (SparseEmbedding)super.getActualInstance();
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        int validCount = 0;
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            DenseEmbedding.validateJsonElement(jsonElement);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for DenseEmbedding failed with `%s`.", e.getMessage()));
        }
        try {
            SparseEmbedding.validateJsonElement(jsonElement);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for SparseEmbedding failed with `%s`.", e.getMessage()));
        }
        if (validCount != 1) {
            throw new IOException(String.format("The JSON string is invalid for Embedding with oneOf schemas: DenseEmbedding, SparseEmbedding. %d class(es) match the result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", validCount, errorMessages, jsonElement.toString()));
        }
    }

    public static Embedding fromJson(String jsonString) throws IOException {
        return (Embedding)JSON.getGson().fromJson(jsonString, Embedding.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("DenseEmbedding", DenseEmbedding.class);
        schemas.put("SparseEmbedding", SparseEmbedding.class);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Embedding.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterDenseEmbedding = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DenseEmbedding.class));
            final TypeAdapter adapterSparseEmbedding = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SparseEmbedding.class));
            return new TypeAdapter<Embedding>(){

                public void write(JsonWriter out, Embedding value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof DenseEmbedding) {
                        JsonElement element = adapterDenseEmbedding.toJsonTree((Object)((DenseEmbedding)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    if (value.getActualInstance() instanceof SparseEmbedding) {
                        JsonElement element = adapterSparseEmbedding.toJsonTree((Object)((SparseEmbedding)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match oneOf schemas: DenseEmbedding, SparseEmbedding");
                }

                public Embedding read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    int match = 0;
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        DenseEmbedding.validateJsonElement(jsonElement);
                        actualAdapter = adapterDenseEmbedding;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'DenseEmbedding'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for DenseEmbedding failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'DenseEmbedding'", e);
                    }
                    try {
                        SparseEmbedding.validateJsonElement(jsonElement);
                        actualAdapter = adapterSparseEmbedding;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'SparseEmbedding'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for SparseEmbedding failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'SparseEmbedding'", e);
                    }
                    if (match == 1) {
                        Embedding ret = new Embedding();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }
                    throw new IOException(String.format("Failed deserialization for Embedding: %d classes match result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", match, errorMessages, jsonElement.toString()));
                }
            }.nullSafe();
        }
    }
}

