/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.SystemPropertyUtil;
import io.scalecube.socketio.ServerBootstrapFactory;
import io.scalecube.socketio.ServerConfiguration;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultServerBootstrapFactory
implements ServerBootstrapFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServerBootstrapFactory.class);
    private static final int BOSS_THREAD_NUM = 2;
    private static final int IO_THREAD_NUM = 0;
    private static boolean envSupportEpoll;
    private final boolean epollEnabled;

    public DefaultServerBootstrapFactory(ServerConfiguration config) {
        this.epollEnabled = config.isEpollEnabled();
    }

    @Override
    public ServerBootstrap createServerBootstrap() {
        EventLoopGroup bossGroup = this.createEventLoopGroup(2, "socketio-boss");
        EventLoopGroup workerGroup = this.createEventLoopGroup(0, "socketio-io");
        return ((ServerBootstrap)new ServerBootstrap().group(bossGroup, workerGroup).channel(this.serverChannelClass())).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.SO_REUSEADDR, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
    }

    private EventLoopGroup createEventLoopGroup(int threadNum, String poolName) {
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(poolName, true);
        return this.isEpollSupported() ? new EpollEventLoopGroup(threadNum, (ThreadFactory)threadFactory) : new NioEventLoopGroup(threadNum, (ThreadFactory)threadFactory);
    }

    private Class<? extends ServerSocketChannel> serverChannelClass() {
        return this.isEpollSupported() ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
    }

    private boolean isEpollSupported() {
        return this.epollEnabled && envSupportEpoll;
    }

    static {
        String name = SystemPropertyUtil.get((String)"os.name").toLowerCase(Locale.UK).trim();
        if (!name.contains("linux")) {
            envSupportEpoll = false;
            LOGGER.warn("Env doesn't support epoll transport");
        } else {
            try {
                Class.forName("io.netty.channel.epoll.Native");
                envSupportEpoll = true;
                LOGGER.info("Use epoll transport");
            }
            catch (Throwable t) {
                LOGGER.warn("Tried to use epoll transport, but it's not supported by host OS (or no corresponding libs included) using NIO instead, cause: ", t);
                envSupportEpoll = false;
            }
        }
    }
}

