/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import javax.net.ssl.SSLContext;

public final class ServerConfiguration {
    public static final ServerConfiguration DEFAULT = ServerConfiguration.builder().build();
    public static final int DEFAULT_PORT = 8080;
    public static final int DEFAULT_HEARTBEAT_TIMEOUT = 60;
    public static final int DEFAULT_HEARTBEAT_INTERVAL = 25;
    public static final int DEFAULT_CLOSE_TIMEOUT = 60;
    public static final String DEFAULT_TRANSPORTS = "websocket,flashsocket,xhr-polling,jsonp-polling";
    public static final boolean DEFAULT_ALWAYS_SECURE_WEB_SOCKET_LOCATION = false;
    public static final String DEFAULT_REMOTE_ADDRESS_HEADER = null;
    public static final boolean DEFAULT_EVENT_EXECUTOR_ENABLED = true;
    public static final int DEFAULT_EVENT_EXECUTOR_THREAD_NUMBER = Runtime.getRuntime().availableProcessors() * 2;
    public static final int DEFAULT_MAX_WEB_SOCKET_FRAME_SIZE = 65536;
    public static final SslContext DEFAULT_SSL_CONTEXT = null;
    public static final boolean DEFAULT_EPOLL_ENABLED = true;
    public static final boolean DEFAULT_HTTP_COMPRESSION_ENABLED = false;
    public static final boolean DEFAULT_WEBSOCKET_COMPRESSION_ENABLED = false;
    private final int port;
    private final int heartbeatTimeout;
    private final int heartbeatInterval;
    private final int closeTimeout;
    private final String transports;
    private final boolean alwaysSecureWebSocketLocation;
    private final String remoteAddressHeader;
    private final boolean eventExecutorEnabled;
    private final int eventExecutorThreadNumber;
    private final int maxWebSocketFrameSize;
    private final SslContext sslContext;
    private final boolean epollEnabled;
    private final boolean httpCompressionEnabled;
    private final boolean websocketCompressionEnabled;

    private ServerConfiguration(Builder builder) {
        this.port = builder.port;
        this.heartbeatTimeout = builder.heartbeatTimeout;
        this.heartbeatInterval = builder.heartbeatInterval;
        this.closeTimeout = builder.closeTimeout;
        this.transports = builder.transports;
        this.alwaysSecureWebSocketLocation = builder.alwaysSecureWebSocketLocation;
        this.remoteAddressHeader = builder.remoteAddressHeader;
        this.eventExecutorEnabled = builder.eventExecutorEnabled;
        this.eventExecutorThreadNumber = builder.eventExecutorThreadNumber;
        this.maxWebSocketFrameSize = builder.maxWebSocketFrameSize;
        this.sslContext = builder.sslContext;
        this.epollEnabled = builder.epollEnabled;
        this.httpCompressionEnabled = builder.httpCompressionEnabled;
        this.websocketCompressionEnabled = builder.websocketCompressionEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getPort() {
        return this.port;
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public int getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public int getCloseTimeout() {
        return this.closeTimeout;
    }

    public String getTransports() {
        return this.transports;
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public boolean isAlwaysSecureWebSocketLocation() {
        return this.alwaysSecureWebSocketLocation;
    }

    public String getRemoteAddressHeader() {
        return this.remoteAddressHeader;
    }

    public boolean isEventExecutorEnabled() {
        return this.eventExecutorEnabled;
    }

    public int getEventExecutorThreadNumber() {
        return this.eventExecutorThreadNumber;
    }

    public int getMaxWebSocketFrameSize() {
        return this.maxWebSocketFrameSize;
    }

    public boolean isEpollEnabled() {
        return this.epollEnabled;
    }

    public boolean isHttpCompressionEnabled() {
        return this.httpCompressionEnabled;
    }

    public boolean isWebsocketCompressionEnabled() {
        return this.websocketCompressionEnabled;
    }

    public String toString() {
        return "ServerConfiguration{port=" + this.port + ", ssl=" + (this.sslContext != null) + ", heartbeatTimeout=" + this.heartbeatTimeout + ", heartbeatInterval=" + this.heartbeatInterval + ", closeTimeout=" + this.closeTimeout + ", transports='" + this.transports + '\'' + ", alwaysSecureWebSocketLocation=" + this.alwaysSecureWebSocketLocation + ", remoteAddressHeader=" + this.remoteAddressHeader + ", eventExecutorEnabled=" + this.eventExecutorEnabled + ", eventExecutorThreadNumber=" + this.eventExecutorThreadNumber + ", maxWebSocketFrameSize=" + this.maxWebSocketFrameSize + ", epollEnabled=" + this.epollEnabled + ", httpCompressionEnabled=" + this.httpCompressionEnabled + ", websocketCompressionEnabled=" + this.websocketCompressionEnabled + '}';
    }

    public static class Builder {
        private int port = 8080;
        private int heartbeatTimeout = 60;
        private int heartbeatInterval = 25;
        private int closeTimeout = 60;
        private String transports = "websocket,flashsocket,xhr-polling,jsonp-polling";
        private boolean alwaysSecureWebSocketLocation = false;
        private String remoteAddressHeader = DEFAULT_REMOTE_ADDRESS_HEADER;
        private boolean eventExecutorEnabled = true;
        private int eventExecutorThreadNumber = DEFAULT_EVENT_EXECUTOR_THREAD_NUMBER;
        private int maxWebSocketFrameSize = 65536;
        private SslContext sslContext = DEFAULT_SSL_CONTEXT;
        private boolean epollEnabled = true;
        private boolean httpCompressionEnabled = false;
        private boolean websocketCompressionEnabled = false;

        private Builder() {
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder sslContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.sslContext = sslContext != null ? new JdkSslContext(sslContext, false, ClientAuth.NONE) : null;
            return this;
        }

        public Builder heartbeatTimeout(int heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        public Builder heartbeatInterval(int heartbeatInterval) {
            this.heartbeatInterval = heartbeatInterval;
            return this;
        }

        public Builder closeTimeout(int closeTimeout) {
            this.closeTimeout = closeTimeout;
            return this;
        }

        public Builder transports(String transports) {
            this.transports = transports;
            return this;
        }

        public Builder alwaysSecureWebSocketLocation(boolean alwaysSecureWebSocketLocation) {
            this.alwaysSecureWebSocketLocation = alwaysSecureWebSocketLocation;
            return this;
        }

        public Builder remoteAddressHeader(String remoteAddressHeader) {
            this.remoteAddressHeader = remoteAddressHeader;
            return this;
        }

        public Builder maxWebSocketFrameSize(int maxWebSocketFrameSize) {
            this.maxWebSocketFrameSize = maxWebSocketFrameSize;
            return this;
        }

        public Builder eventExecutorEnabled(boolean eventExecutorEnabled) {
            this.eventExecutorEnabled = eventExecutorEnabled;
            return this;
        }

        public Builder eventExecutorThreadNumber(int eventExecutorThreadNumber) {
            this.eventExecutorThreadNumber = eventExecutorThreadNumber;
            return this;
        }

        public Builder epollEnabled(boolean epollEnabled) {
            this.epollEnabled = epollEnabled;
            return this;
        }

        public Builder httpCompressionEnabled(boolean httpCompressionEnabled) {
            this.httpCompressionEnabled = httpCompressionEnabled;
            return this;
        }

        public Builder websocketCompressionEnabled(boolean websocketCompressionEnabled) {
            this.websocketCompressionEnabled = websocketCompressionEnabled;
            return this;
        }

        public ServerConfiguration build() {
            return new ServerConfiguration(this);
        }
    }
}

