/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.util.HashedWheelTimer;
import io.scalecube.socketio.DefaultServerBootstrapFactory;
import io.scalecube.socketio.PipelineModifier;
import io.scalecube.socketio.ServerBootstrapFactory;
import io.scalecube.socketio.ServerConfiguration;
import io.scalecube.socketio.SocketIOListener;
import io.scalecube.socketio.pipeline.SocketIOChannelInitializer;
import io.scalecube.socketio.session.SocketIOHeartbeatScheduler;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SocketIOServer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ServerConfiguration configuration;
    private SocketIOListener listener;
    private PipelineModifier pipelineModifier;
    private HashedWheelTimer timer;
    private volatile State state = State.STOPPED;
    private ServerBootstrapFactory serverBootstrapFactory;
    private ServerBootstrap bootstrap;

    private SocketIOServer(ServerConfiguration configuration) {
        this.configuration = configuration;
    }

    public static SocketIOServer newInstance() {
        return new SocketIOServer(ServerConfiguration.DEFAULT);
    }

    public static SocketIOServer newInstance(int port) {
        return new SocketIOServer(ServerConfiguration.builder().port(port).build());
    }

    public static SocketIOServer newInstance(int port, SSLContext sslContext) {
        JdkSslContext nettySslContext = new JdkSslContext(sslContext, false, ClientAuth.NONE);
        return SocketIOServer.newInstance(port, (SslContext)nettySslContext);
    }

    public static SocketIOServer newInstance(int port, SslContext sslContext) {
        return new SocketIOServer(ServerConfiguration.builder().port(port).sslContext(sslContext).build());
    }

    public static SocketIOServer newInstance(ServerConfiguration config) {
        return new SocketIOServer(config);
    }

    public synchronized void start() {
        if (this.isStarted()) {
            throw new IllegalStateException("Failed to start Socket.IO server: server already started");
        }
        this.log.info("Socket.IO server starting");
        this.timer = new HashedWheelTimer();
        this.timer.start();
        SocketIOHeartbeatScheduler.setHashedWheelTimer(this.timer);
        SocketIOHeartbeatScheduler.setHeartbeatInterval(this.configuration.getHeartbeatInterval());
        SocketIOHeartbeatScheduler.setHeartbeatTimeout(this.configuration.getHeartbeatTimeout());
        ServerBootstrapFactory bootstrapFactory = this.serverBootstrapFactory != null ? this.serverBootstrapFactory : new DefaultServerBootstrapFactory(this.configuration);
        this.bootstrap = bootstrapFactory.createServerBootstrap();
        this.bootstrap.childHandler((ChannelHandler)new SocketIOChannelInitializer(this.configuration, this.listener, this.pipelineModifier));
        this.bootstrap.bind(this.configuration.getPort()).syncUninterruptibly();
        this.state = State.STARTED;
        this.log.info("Socket.IO server started: {}", (Object)this.configuration);
    }

    public synchronized void stop() {
        if (this.isStopped()) {
            throw new IllegalStateException("Failed to stop Socket.IO server: server already stopped");
        }
        this.log.info("Socket.IO server stopping");
        this.timer.stop();
        this.bootstrap.config().group().shutdownGracefully().syncUninterruptibly();
        this.state = State.STOPPED;
        this.log.info("Socket.IO server stopped");
    }

    public synchronized void restart() {
        if (this.isStarted()) {
            this.stop();
        }
        this.start();
    }

    public boolean isStarted() {
        return this.state == State.STARTED;
    }

    public boolean isStopped() {
        return this.state == State.STOPPED;
    }

    public SocketIOListener getListener() {
        return this.listener;
    }

    public void setListener(SocketIOListener listener) {
        this.listener = listener;
    }

    public PipelineModifier getPipelineModifier() {
        return this.pipelineModifier;
    }

    public void setPipelineModifier(PipelineModifier pipelineModifier) {
        this.pipelineModifier = pipelineModifier;
    }

    public ServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ServerConfiguration configuration) {
        this.configuration = configuration;
    }

    public ServerBootstrapFactory getServerBootstrapFactory() {
        return this.serverBootstrapFactory;
    }

    public void setServerBootstrapFactory(ServerBootstrapFactory serverBootstrapFactory) {
        this.serverBootstrapFactory = serverBootstrapFactory;
    }

    private static enum State {
        STARTED,
        STOPPED;

    }
}

