/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.packets;

import io.netty.util.CharsetUtil;

public enum PacketType {
    DISCONNECT(0),
    CONNECT(1),
    HEARTBEAT(2),
    MESSAGE(3),
    JSON(4),
    EVENT(5),
    ACK(6),
    ERROR(7),
    NOOP(8);

    private static final int TYPES_SIZE = 9;
    private static final PacketType[] valueToType;
    private final int value;
    private final byte[] valueAsBytes;

    private PacketType(int value) {
        this.value = value;
        this.valueAsBytes = String.valueOf(value).getBytes(CharsetUtil.UTF_8);
    }

    public int getValue() {
        return this.value;
    }

    public byte[] getValueAsBytes() {
        return this.valueAsBytes;
    }

    public static PacketType valueOf(int value) {
        return valueToType[value];
    }

    static {
        valueToType = new PacketType[9];
        PacketType[] packetTypeArray = PacketType.values();
        int n = packetTypeArray.length;
        for (int i = 0; i < n; ++i) {
            PacketType type;
            PacketType.valueToType[type.getValue()] = type = packetTypeArray[i];
        }
    }
}

