/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.pipeline;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.ReferenceCountUtil;
import io.scalecube.socketio.packets.Packet;
import io.scalecube.socketio.packets.PacketType;
import io.scalecube.socketio.pipeline.PipelineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class DisconnectHandler
extends ChannelInboundHandlerAdapter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String DISCONNECT = "disconnect";

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            HttpMethod requestMethod = req.method();
            QueryStringDecoder queryDecoder = new QueryStringDecoder(req.uri());
            String requestPath = queryDecoder.path();
            boolean disconnect = queryDecoder.parameters().containsKey(DISCONNECT);
            if (disconnect) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received HTTP disconnect request: {} {} from channel: {}", new Object[]{requestMethod, requestPath, ctx.channel()});
                }
                String sessionId = PipelineUtils.getSessionId(requestPath);
                Packet disconnectPacket = new Packet(PacketType.DISCONNECT, sessionId);
                disconnectPacket.setOrigin(PipelineUtils.getOrigin(req));
                ctx.fireChannelRead((Object)disconnectPacket);
                ReferenceCountUtil.release((Object)msg);
                return;
            }
        }
        ctx.fireChannelRead(msg);
    }
}

