/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.scalecube.socketio.pipeline.PipelineUtils;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class FlashPolicyHandler
extends ChannelInboundHandlerAdapter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final ByteBuf policyRequestBuffer = Unpooled.copiedBuffer((CharSequence)"<policy-file-request/>", (Charset)CharsetUtil.UTF_8);
    private static final String policyResponse = "<?xml version=\"1.0\"?><!DOCTYPE cross-domain-policy SYSTEM \"/xml/dtds/cross-domain-policy.dtd\"><cross-domain-policy>    <site-control permitted-cross-domain-policies=\"master-only\"/>   <allow-access-from domain=\"*\" to-ports=\"*\" /></cross-domain-policy>";

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf data;
            ByteBuf message = (ByteBuf)msg;
            if (message.readableBytes() >= policyRequestBuffer.readableBytes() && (data = message.slice(0, policyRequestBuffer.readableBytes())).equals((Object)policyRequestBuffer)) {
                if (ctx.pipeline().get("ssl-handler") != null) {
                    ctx.pipeline().remove("ssl-handler");
                }
                ByteBuf response = PipelineUtils.copiedBuffer(ctx.alloc(), policyResponse);
                ChannelFuture f = ctx.writeAndFlush((Object)response);
                f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Sent flash policy file to channel: {}", (Object)ctx.channel());
                }
                message.release();
                return;
            }
            ctx.pipeline().remove((ChannelHandler)this);
        }
        ctx.fireChannelRead(msg);
    }
}

