/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.scalecube.socketio.pipeline.PipelineUtils;
import java.io.IOException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HandshakeHandler
extends ChannelInboundHandlerAdapter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String handshakePath;
    private final String commonHandshakeParameters;

    public HandshakeHandler(String handshakePath, int heartbeatTimeout, int closeTimeout, String transports) {
        this.handshakePath = handshakePath;
        this.commonHandshakeParameters = ":" + heartbeatTimeout + ":" + closeTimeout + ":" + transports;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            HttpMethod requestMethod = req.method();
            QueryStringDecoder queryDecoder = new QueryStringDecoder(req.uri());
            String requestPath = queryDecoder.path();
            if (!requestPath.startsWith(this.handshakePath)) {
                this.log.warn("Received HTTP bad request: {} {} from channel: {}", new Object[]{requestMethod, requestPath, ctx.channel()});
                DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
                ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
                f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                ReferenceCountUtil.release((Object)req);
                return;
            }
            if (HttpMethod.GET.equals((Object)requestMethod) && requestPath.equals(this.handshakePath)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received HTTP handshake request: {} {} from channel: {}", new Object[]{requestMethod, requestPath, ctx.channel()});
                }
                this.handshake(ctx, req, queryDecoder);
                ReferenceCountUtil.release((Object)req);
                return;
            }
        }
        super.channelRead(ctx, msg);
    }

    private void handshake(ChannelHandlerContext ctx, HttpRequest req, QueryStringDecoder queryDecoder) throws IOException {
        String sessionId = UUID.randomUUID().toString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("New sessionId: {} generated", (Object)sessionId);
        }
        String handshakeMessage = this.getHandshakeMessage(sessionId, queryDecoder);
        ByteBuf content = PipelineUtils.copiedBuffer(ctx.alloc(), handshakeMessage);
        HttpResponse res = PipelineUtils.createHttpResponse(PipelineUtils.getOrigin(req), content, false);
        ChannelFuture f = ctx.writeAndFlush((Object)res);
        f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sent handshake response: {} to channel: {}", (Object)handshakeMessage, (Object)ctx.channel());
        }
    }

    private String getHandshakeMessage(String sessionId, QueryStringDecoder queryDecoder) throws IOException {
        String jsonpParam = PipelineUtils.extractParameter(queryDecoder, "jsonp");
        String handshakeParameters = sessionId + this.commonHandshakeParameters;
        if (jsonpParam != null) {
            return "io.j[" + jsonpParam + "](\"" + handshakeParameters + "\");";
        }
        return handshakeParameters;
    }
}

