/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.pipeline;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.scalecube.socketio.packets.Packet;
import io.scalecube.socketio.packets.PacketType;
import io.scalecube.socketio.session.ManagedSession;
import io.scalecube.socketio.session.SessionStorage;

@ChannelHandler.Sharable
public class HeartbeatHandler
extends ChannelInboundHandlerAdapter {
    private final SessionStorage sessionFactory;

    public HeartbeatHandler(SessionStorage sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Packet packet;
        if (msg instanceof Packet && (packet = (Packet)msg).getType() == PacketType.HEARTBEAT) {
            String sessionId = packet.getSessionId();
            ManagedSession session = this.sessionFactory.getSessionIfExist(sessionId);
            if (session != null) {
                session.acceptPacket(ctx.channel(), packet);
                session.acceptHeartbeat();
            }
            return;
        }
        super.channelRead(ctx, msg);
    }
}

