/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.scalecube.socketio.TransportType;
import io.scalecube.socketio.packets.ConnectPacket;
import io.scalecube.socketio.packets.Packet;
import io.scalecube.socketio.pipeline.PipelineUtils;
import io.scalecube.socketio.serialization.PacketFramer;
import java.net.SocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class JsonpPollingHandler
extends ChannelInboundHandlerAdapter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String connectPath;
    private final String remoteAddressHeader;

    public JsonpPollingHandler(String handshakePath, String remoteAddressHeader) {
        this.connectPath = handshakePath + TransportType.JSONP_POLLING.getName();
        this.remoteAddressHeader = remoteAddressHeader;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest req = (FullHttpRequest)msg;
            HttpMethod requestMethod = req.method();
            QueryStringDecoder queryDecoder = new QueryStringDecoder(req.uri());
            String requestPath = queryDecoder.path();
            if (requestPath.startsWith(this.connectPath)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received HTTP JSONP-Polling request: {} {} from channel: {}", new Object[]{requestMethod, requestPath, ctx.channel()});
                }
                String sessionId = PipelineUtils.getSessionId(requestPath);
                String origin = PipelineUtils.getOrigin((HttpRequest)req);
                if (HttpMethod.GET.equals((Object)requestMethod)) {
                    SocketAddress clientIp = PipelineUtils.resolveClientIpByRemoteAddressHeader((HttpMessage)req, this.remoteAddressHeader);
                    String jsonpIndexParam = PipelineUtils.extractParameter(queryDecoder, "i");
                    ConnectPacket packet = new ConnectPacket(sessionId, origin);
                    packet.setTransportType(TransportType.JSONP_POLLING);
                    packet.setJsonpIndexParam(jsonpIndexParam);
                    packet.setRemoteAddress(clientIp);
                    ctx.fireChannelRead((Object)packet);
                } else if (HttpMethod.POST.equals((Object)requestMethod)) {
                    ByteBuf buffer = req.content();
                    String content = buffer.toString(CharsetUtil.UTF_8);
                    if (content.startsWith("d=")) {
                        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(content, CharsetUtil.UTF_8, false);
                        content = PipelineUtils.extractParameter(queryStringDecoder, "d");
                        content = this.prepareJsonpContent(content);
                        ByteBuf buf = PipelineUtils.copiedBuffer(ctx.alloc(), content);
                        List<Packet> packets = PacketFramer.decodePacketsFrame(buf);
                        buf.release();
                        for (Packet packet : packets) {
                            packet.setSessionId(sessionId);
                            packet.setOrigin(origin);
                            ctx.fireChannelRead((Object)packet);
                        }
                    } else {
                        this.log.warn("Can't process HTTP JSONP-Polling message. Incorrect content format: {} from channel: {}", (Object)content, (Object)ctx.channel());
                    }
                } else {
                    this.log.warn("Can't process HTTP JSONP-Polling request. Unknown request method: {} from channel: {}", (Object)requestMethod, (Object)ctx.channel());
                }
                ReferenceCountUtil.release((Object)msg);
                return;
            }
        }
        super.channelRead(ctx, msg);
    }

    private String prepareJsonpContent(String content) {
        if (content.startsWith("\"")) {
            content = content.substring(1);
        }
        if (content.endsWith("\"")) {
            content = content.substring(0, content.length() - 1);
        }
        content = content.replace("\\\\", "\\");
        content = content.replace("\\\"", "\"");
        return content;
    }
}

