/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.pipeline;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.scalecube.socketio.Session;
import io.scalecube.socketio.SocketIOListener;
import io.scalecube.socketio.packets.ConnectPacket;
import io.scalecube.socketio.packets.IPacket;
import io.scalecube.socketio.packets.Packet;
import io.scalecube.socketio.packets.PacketType;
import io.scalecube.socketio.pipeline.UnsupportedPacketTypeException;
import io.scalecube.socketio.session.ManagedSession;
import io.scalecube.socketio.session.SessionDisconnectHandler;
import io.scalecube.socketio.session.SessionStorage;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class PacketDispatcherHandler
extends ChannelInboundHandlerAdapter
implements SessionDisconnectHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SessionStorage sessionStorage;
    private final SocketIOListener listener;

    public PacketDispatcherHandler(SessionStorage sessionStorage, SocketIOListener listener) {
        this.sessionStorage = sessionStorage;
        this.listener = listener;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Channel active: {}", (Object)ctx.channel());
        }
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Channel inactive: {}", (Object)ctx.channel());
        }
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof IOException) {
            this.log.info("Exception caught at channel: {}, {}", (Object)ctx.channel(), (Object)cause.getMessage());
        } else {
            this.log.error("Exception caught at channel: {}, {}", (Object)ctx.channel(), (Object)cause);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object message) throws Exception {
        Channel channel = ctx.channel();
        if (message instanceof IPacket) {
            IPacket packet = (IPacket)message;
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Dispatching packet: {} from channel: {}", (Object)packet, (Object)channel);
                }
                this.dispatchPacket(channel, packet);
            }
            catch (Exception e) {
                this.log.error("Failed to dispatch packet: {}", (Object)packet, (Object)e);
            }
        } else {
            this.log.warn("Received unknown message: {} from channel {}", message, (Object)channel);
        }
    }

    private void dispatchPacket(Channel channel, IPacket packet) throws Exception {
        if (packet instanceof ConnectPacket) {
            ConnectPacket connectPacket = (ConnectPacket)packet;
            ManagedSession session = this.sessionStorage.getSession(connectPacket, channel, this);
            this.onConnectPacket(channel, session);
        } else if (packet instanceof Packet) {
            Packet message = (Packet)packet;
            String sessionId = packet.getSessionId();
            ManagedSession session = this.sessionStorage.getSessionIfExist(sessionId);
            if (session != null) {
                this.onPacket(channel, session, message);
            } else if (message.getData() != null) {
                message.getData().release();
            }
        } else {
            throw new UnsupportedPacketTypeException(packet);
        }
    }

    private void onConnectPacket(Channel channel, ManagedSession session) {
        boolean initialConnect = session.connect(channel);
        if (initialConnect && this.listener != null) {
            this.listener.onConnect(session);
        }
    }

    private void onPacket(Channel channel, ManagedSession session, Packet packet) {
        if (packet.getType() == PacketType.DISCONNECT) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Got {} packet, {} session will be disconnected", (Object)packet.getType().name(), (Object)session.getSessionId());
            }
            session.disconnect(channel);
        } else {
            session.acceptPacket(channel, packet);
            if (this.listener != null && (packet.getType() == PacketType.MESSAGE || packet.getType() == PacketType.JSON)) {
                this.listener.onMessage(session, packet.getData());
            }
        }
    }

    @Override
    public void onSessionDisconnect(Session session) {
        if (this.sessionStorage.containSession(session.getSessionId())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Client with sessionId: {} disconnected", (Object)session.getSessionId());
            }
            this.sessionStorage.removeSession(session.getSessionId());
            if (this.listener != null) {
                this.listener.onDisconnect(session);
            }
        }
    }
}

