/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCounted;
import io.scalecube.socketio.TransportType;
import io.scalecube.socketio.packets.IPacket;
import io.scalecube.socketio.packets.Packet;
import io.scalecube.socketio.packets.PacketsFrame;
import io.scalecube.socketio.pipeline.PipelineUtils;
import io.scalecube.socketio.pipeline.UnsupportedPacketTypeException;
import io.scalecube.socketio.pipeline.UnsupportedTransportTypeException;
import io.scalecube.socketio.serialization.PacketEncoder;
import io.scalecube.socketio.serialization.PacketFramer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class PacketEncoderHandler
extends MessageToMessageEncoder<Object> {
    private static final String JSONP_TEMPLATE = "io.j[%s]('%s');";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
        if (msg instanceof IPacket) {
            TransportType transportType;
            IPacket packet = (IPacket)msg;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending packet: {} to channel: {}", msg, (Object)ctx.channel());
            }
            ByteBuf encodedPacket = this.encodePacket(packet);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Encoded packet: {}", (Object)encodedPacket);
            }
            if ((transportType = packet.getTransportType()) == TransportType.WEBSOCKET || transportType == TransportType.FLASHSOCKET) {
                out.add(new TextWebSocketFrame(encodedPacket));
                return;
            } else if (transportType == TransportType.XHR_POLLING) {
                out.add(PipelineUtils.createHttpResponse(packet.getOrigin(), encodedPacket, false));
                return;
            } else {
                if (transportType != TransportType.JSONP_POLLING) throw new UnsupportedTransportTypeException(transportType);
                String jsonpIndexParam = packet.getJsonpIndexParam() != null ? packet.getJsonpIndexParam() : "0";
                String encodedStringPacket = encodedPacket.toString(CharsetUtil.UTF_8);
                encodedPacket.release();
                String encodedJsonpPacket = String.format(JSONP_TEMPLATE, jsonpIndexParam, encodedStringPacket);
                HttpResponse httpResponse = PipelineUtils.createHttpResponse(packet.getOrigin(), PipelineUtils.copiedBuffer(ctx.alloc(), encodedJsonpPacket), true);
                httpResponse.headers().add("X-XSS-Protection", (Object)"0");
                out.add(httpResponse);
            }
            return;
        } else {
            if (msg instanceof ReferenceCounted) {
                ((ReferenceCounted)msg).retain();
            }
            out.add(msg);
        }
    }

    private ByteBuf encodePacket(IPacket msg) throws Exception {
        if (msg instanceof PacketsFrame) {
            return PacketFramer.encodePacketsFrame((PacketsFrame)msg);
        }
        if (msg instanceof Packet) {
            return PacketEncoder.encodePacket((Packet)msg);
        }
        throw new UnsupportedPacketTypeException(msg);
    }
}

