/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PipelineUtils {
    private static final Logger log = LoggerFactory.getLogger(PipelineUtils.class);

    private PipelineUtils() {
    }

    public static String getSessionId(String requestPath) {
        String[] parts = requestPath.split("[/]");
        if (parts.length > 4 && !parts[4].isEmpty()) {
            String[] idsplit = parts[4].split("[?]");
            if (idsplit[0] != null && idsplit[0].length() > 0) {
                return idsplit[0];
            }
            return parts[4];
        }
        return null;
    }

    public static String getOrigin(HttpRequest req) {
        return req.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
    }

    public static String extractParameter(QueryStringDecoder queryDecoder, String key) {
        Map params = queryDecoder.parameters();
        List paramsByKey = (List)params.get(key);
        return paramsByKey != null ? (String)paramsByKey.get(0) : null;
    }

    public static HttpResponse createHttpResponse(String origin, ByteBuf content, boolean json) {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
        if (json) {
            res.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/javascript; charset=UTF-8");
        } else {
            res.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        }
        res.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        if (origin != null) {
            res.headers().add((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)origin);
            res.headers().add((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)"true");
        }
        HttpUtil.setContentLength((HttpMessage)res, (long)content.readableBytes());
        return res;
    }

    public static ByteBuf copiedBuffer(ByteBufAllocator allocator, String message) {
        ByteBuf buffer = allocator.buffer();
        buffer.writeBytes(message.getBytes(CharsetUtil.UTF_8));
        return buffer;
    }

    public static SocketAddress resolveClientIpByRemoteAddressHeader(HttpMessage message, String headerName) {
        InetSocketAddress clientIp = null;
        if (headerName != null && !headerName.trim().isEmpty()) {
            String ip = null;
            try {
                ip = message.headers().get(headerName);
                if (ip != null) {
                    ip = ip.split(",")[0];
                    clientIp = new InetSocketAddress(InetAddress.getByName(ip), 0);
                }
            }
            catch (Exception e) {
                log.warn("Failed to parse IP address: {} from http header: {}", (Object)ip, (Object)headerName);
            }
        }
        return clientIp;
    }
}

