/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.stream.ChunkedStream;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.activation.MimetypesFileTypeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ResourceHandler
extends ChannelInboundHandlerAdapter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String HTTP_DATE_GMT_TIMEZONE = "GMT";
    public static final int HTTP_CACHE_SECONDS = 60;
    private final Map<String, URL> resources = new HashMap<String, URL>();

    public void addResource(String pathPart, String resourcePath) {
        URL resUrl = ((Object)((Object)this)).getClass().getResource(resourcePath);
        if (resUrl == null) {
            this.log.error("The specified resource was not found: " + resourcePath);
            return;
        }
        this.resources.put(pathPart, resUrl);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        HttpRequest req;
        QueryStringDecoder queryDecoder;
        String requestPath;
        URL resUrl;
        if (msg instanceof HttpRequest && (resUrl = this.resources.get(requestPath = (queryDecoder = new QueryStringDecoder((req = (HttpRequest)msg).uri())).path())) != null) {
            URLConnection fileUrl;
            long lastModified;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received HTTP resource request: {} {} from channel: {}", new Object[]{req.method(), requestPath, ctx.channel()});
            }
            if (this.isNotModified(req, lastModified = (fileUrl = resUrl.openConnection()).getLastModified())) {
                this.sendNotModified(ctx);
                return;
            }
            InputStream is = fileUrl.getInputStream();
            if (is == null) {
                this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                return;
            }
            DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            HttpUtil.setContentLength((HttpMessage)res, (long)fileUrl.getContentLengthLong());
            this.setContentTypeHeader((HttpResponse)res, fileUrl);
            this.setDateAndCacheHeaders((HttpResponse)res, lastModified);
            ctx.write((Object)res);
            ctx.pipeline().addBefore(ctx.name(), "chunked-writer-handler", (ChannelHandler)new ChunkedWriteHandler());
            ChannelFuture writeFuture = ctx.writeAndFlush((Object)new ChunkedStream(is, fileUrl.getContentLength()));
            writeFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        super.channelRead(ctx, msg);
    }

    private boolean isNotModified(HttpRequest request, long lastModified) throws ParseException {
        String ifModifiedSince = request.headers().get((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE);
        if (ifModifiedSince != null && !ifModifiedSince.equals("")) {
            long fileLastModifiedSeconds;
            SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
            Date ifModifiedSinceDate = dateFormatter.parse(ifModifiedSince);
            long ifModifiedSinceDateSeconds = ifModifiedSinceDate.getTime() / 1000L;
            return ifModifiedSinceDateSeconds == (fileLastModifiedSeconds = lastModified / 1000L);
        }
        return false;
    }

    private void sendNotModified(ChannelHandlerContext ctx) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        this.setDateHeader((HttpResponse)response);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void setDateHeader(HttpResponse response) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set((CharSequence)HttpHeaderNames.DATE, (Object)dateFormatter.format(time.getTime()));
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        ByteBuf content = Unpooled.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)CharsetUtil.UTF_8);
        ctx.write((Object)response);
        ctx.writeAndFlush((Object)content).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void setDateAndCacheHeaders(HttpResponse response, long lastModified) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set((CharSequence)HttpHeaderNames.DATE, (Object)dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, 60);
        response.headers().set((CharSequence)HttpHeaderNames.EXPIRES, (Object)dateFormatter.format(time.getTime()));
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"private, max-age=60");
        response.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)dateFormatter.format(new Date(lastModified)));
    }

    private void setContentTypeHeader(HttpResponse response, URLConnection resUrlConnection) {
        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
        String resName = resUrlConnection.getURL().getFile();
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mimeTypesMap.getContentType(resName));
    }
}

