/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.pipeline;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.scalecube.socketio.PipelineModifier;
import io.scalecube.socketio.ServerConfiguration;
import io.scalecube.socketio.SocketIOListener;
import io.scalecube.socketio.TransportType;
import io.scalecube.socketio.pipeline.DisconnectHandler;
import io.scalecube.socketio.pipeline.FlashPolicyHandler;
import io.scalecube.socketio.pipeline.FlashSocketHandler;
import io.scalecube.socketio.pipeline.HandshakeHandler;
import io.scalecube.socketio.pipeline.HeartbeatHandler;
import io.scalecube.socketio.pipeline.JsonpPollingHandler;
import io.scalecube.socketio.pipeline.PacketDispatcherHandler;
import io.scalecube.socketio.pipeline.PacketEncoderHandler;
import io.scalecube.socketio.pipeline.ResourceHandler;
import io.scalecube.socketio.pipeline.WebSocketHandler;
import io.scalecube.socketio.pipeline.XHRPollingHandler;
import io.scalecube.socketio.session.SessionStorage;

public class SocketIOChannelInitializer
extends ChannelInitializer {
    public static final String FLASH_POLICY_HANDLER = "flash-policy-handler";
    public static final String SSL_HANDLER = "ssl-handler";
    public static final String HTTP_RESPONSE_ENCODER = "http-response-encoder";
    public static final String HTTP_REQUEST_DECODER = "http-request-decoder";
    public static final String HTTP_CHUNK_AGGREGATOR = "http-chunk-aggregator";
    public static final String HTTP_COMPRESSION = "http-compression";
    public static final String WEBSOCKET_COMPRESSION = "websocket-compression";
    public static final String WEBSOCKET_FRAME_AGGREGATOR = "websocket-frame-aggregator";
    public static final String FLASH_RESOURCE_HANDLER = "flash-resource-handler";
    public static final String SOCKETIO_PACKET_ENCODER = "socketio-packet-encoder";
    public static final String SOCKETIO_HANDSHAKE_HANDLER = "socketio-handshake-handler";
    public static final String SOCKETIO_DISCONNECT_HANDLER = "socketio-disconnect-handler";
    public static final String SOCKETIO_WEBSOCKET_HANDLER = "socketio-websocket-handler";
    public static final String SOCKETIO_FLASHSOCKET_HANDLER = "socketio-flashsocket-handler";
    public static final String SOCKETIO_XHR_POLLING_HANDLER = "socketio-xhr-polling-handler";
    public static final String SOCKETIO_JSONP_POLLING_HANDLER = "socketio-jsonp-polling-handler";
    public static final String SOCKETIO_HEARTBEAT_HANDLER = "socketio-heartbeat-handler";
    public static final String SOCKETIO_PACKET_DISPATCHER = "socketio-packet-dispatcher";
    private static final int PROTOCOL = 1;
    private static final String CONTEXT_PATH = "/socket.io";
    private static final String HANDSHAKE_PATH = "/socket.io/1/";
    private static final int MAX_HTTP_CONTENT_LENGTH = 0x100000;
    private static final String FLASH_SOCKET_RESOURCE_PATH = "/static/flashsocket/WebSocketMain.swf";
    private static final String FLASH_SOCKET_INSECURE_RESOURCE_PATH = "/static/flashsocket/WebSocketMainInsecure.swf";
    private final FlashPolicyHandler flashPolicyHandler;
    private final ResourceHandler flashResourceHandler;
    private final PacketEncoderHandler packetEncoderHandler;
    private final HandshakeHandler handshakeHandler;
    private final DisconnectHandler disconnectHandler;
    private final WebSocketHandler webSocketHandler;
    private final FlashSocketHandler flashSocketHandler;
    private final XHRPollingHandler xhrPollingHandler;
    private final JsonpPollingHandler jsonpPollingHandler;
    private final HeartbeatHandler heartbeatHandler;
    private final EventExecutorGroup eventExecutorGroup;
    private final PacketDispatcherHandler packetDispatcherHandler;
    private final SslContext sslContext;
    private final boolean isFlashSupported;
    private final boolean isJsonpSupported;
    private final boolean isHttpCompressionEnabled;
    private final boolean isWebsocketCompressionEnabled;
    private final PipelineModifier pipelineModifier;

    public SocketIOChannelInitializer(ServerConfiguration serverConfiguration, SocketIOListener listener, PipelineModifier pipelineModifier) {
        this.sslContext = serverConfiguration.getSslContext();
        String remoteAddressHeader = serverConfiguration.getRemoteAddressHeader();
        SessionStorage sessionFactory = new SessionStorage(serverConfiguration.getPort());
        this.isFlashSupported = serverConfiguration.getTransports().contains(TransportType.FLASHSOCKET.getName());
        this.isJsonpSupported = serverConfiguration.getTransports().contains(TransportType.JSONP_POLLING.getName());
        this.isWebsocketCompressionEnabled = serverConfiguration.isWebsocketCompressionEnabled();
        this.isHttpCompressionEnabled = serverConfiguration.isHttpCompressionEnabled();
        this.flashPolicyHandler = new FlashPolicyHandler();
        this.flashResourceHandler = new ResourceHandler();
        this.flashResourceHandler.addResource("/socket.io/static/flashsocket/WebSocketMain.swf", FLASH_SOCKET_RESOURCE_PATH);
        this.flashResourceHandler.addResource("/socket.io/static/flashsocket/WebSocketMainInsecure.swf", FLASH_SOCKET_INSECURE_RESOURCE_PATH);
        this.packetEncoderHandler = new PacketEncoderHandler();
        this.handshakeHandler = new HandshakeHandler(HANDSHAKE_PATH, serverConfiguration.getHeartbeatTimeout(), serverConfiguration.getCloseTimeout(), serverConfiguration.getTransports());
        this.disconnectHandler = new DisconnectHandler();
        this.heartbeatHandler = new HeartbeatHandler(sessionFactory);
        boolean secure = this.sslContext != null || serverConfiguration.isAlwaysSecureWebSocketLocation();
        int maxWebSocketFrameSize = serverConfiguration.getMaxWebSocketFrameSize();
        this.webSocketHandler = new WebSocketHandler(HANDSHAKE_PATH, secure, maxWebSocketFrameSize, remoteAddressHeader);
        this.flashSocketHandler = new FlashSocketHandler(HANDSHAKE_PATH, secure, maxWebSocketFrameSize, remoteAddressHeader);
        this.xhrPollingHandler = new XHRPollingHandler(HANDSHAKE_PATH, remoteAddressHeader);
        this.jsonpPollingHandler = new JsonpPollingHandler(HANDSHAKE_PATH, remoteAddressHeader);
        this.packetDispatcherHandler = new PacketDispatcherHandler(sessionFactory, listener);
        if (serverConfiguration.isEventExecutorEnabled()) {
            int nThreads = serverConfiguration.getEventExecutorThreadNumber() > 0 ? serverConfiguration.getEventExecutorThreadNumber() : Runtime.getRuntime().availableProcessors() * 2;
            this.eventExecutorGroup = new DefaultEventExecutorGroup(nThreads);
        } else {
            this.eventExecutorGroup = null;
        }
        this.pipelineModifier = pipelineModifier;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.isFlashSupported) {
            pipeline.addLast(FLASH_POLICY_HANDLER, (ChannelHandler)this.flashPolicyHandler);
        }
        if (this.sslContext != null) {
            pipeline.addLast(SSL_HANDLER, (ChannelHandler)this.sslContext.newHandler(ch.alloc()));
        }
        pipeline.addLast(HTTP_REQUEST_DECODER, (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast(HTTP_CHUNK_AGGREGATOR, (ChannelHandler)new HttpObjectAggregator(0x100000));
        pipeline.addLast(HTTP_RESPONSE_ENCODER, (ChannelHandler)new HttpResponseEncoder());
        if (this.isHttpCompressionEnabled) {
            pipeline.addLast(HTTP_COMPRESSION, (ChannelHandler)new HttpContentCompressor());
        }
        if (this.isFlashSupported) {
            pipeline.addLast(FLASH_RESOURCE_HANDLER, (ChannelHandler)this.flashResourceHandler);
        }
        pipeline.addLast(SOCKETIO_PACKET_ENCODER, (ChannelHandler)this.packetEncoderHandler);
        pipeline.addLast(SOCKETIO_HANDSHAKE_HANDLER, (ChannelHandler)this.handshakeHandler);
        pipeline.addLast(SOCKETIO_DISCONNECT_HANDLER, (ChannelHandler)this.disconnectHandler);
        if (this.isWebsocketCompressionEnabled) {
            pipeline.addLast(WEBSOCKET_COMPRESSION, (ChannelHandler)new WebSocketServerCompressionHandler());
        }
        pipeline.addLast(SOCKETIO_WEBSOCKET_HANDLER, (ChannelHandler)this.webSocketHandler);
        if (this.isFlashSupported) {
            pipeline.addLast(SOCKETIO_FLASHSOCKET_HANDLER, (ChannelHandler)this.flashSocketHandler);
        }
        pipeline.addLast(SOCKETIO_XHR_POLLING_HANDLER, (ChannelHandler)this.xhrPollingHandler);
        if (this.isJsonpSupported) {
            pipeline.addLast(SOCKETIO_JSONP_POLLING_HANDLER, (ChannelHandler)this.jsonpPollingHandler);
        }
        pipeline.addLast(SOCKETIO_HEARTBEAT_HANDLER, (ChannelHandler)this.heartbeatHandler);
        pipeline.addLast(this.eventExecutorGroup, SOCKETIO_PACKET_DISPATCHER, (ChannelHandler)this.packetDispatcherHandler);
        if (this.pipelineModifier != null) {
            this.pipelineModifier.modifyPipeline(pipeline);
        }
    }
}

