/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.pipeline;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.scalecube.socketio.TransportType;
import io.scalecube.socketio.packets.ConnectPacket;
import io.scalecube.socketio.packets.Packet;
import io.scalecube.socketio.pipeline.PipelineUtils;
import io.scalecube.socketio.serialization.PacketDecoder;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class WebSocketHandler
extends ChannelInboundHandlerAdapter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Map<Object, String> sessionIdByChannel = new ConcurrentHashMap<Object, String>();
    private final String connectPath;
    private final boolean secure;
    private final String remoteAddressHeader;
    private final int maxWebSocketFrameSize;

    public WebSocketHandler(String handshakePath, boolean secure, int maxWebSocketFrameSize, String remoteAddressHeader) {
        this.connectPath = handshakePath + this.getTransportType().getName();
        this.secure = secure;
        this.remoteAddressHeader = remoteAddressHeader;
        this.maxWebSocketFrameSize = maxWebSocketFrameSize;
    }

    protected TransportType getTransportType() {
        return TransportType.WEBSOCKET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest req = (FullHttpRequest)msg;
            if (req.method() == HttpMethod.GET && req.uri().startsWith(this.connectPath)) {
                QueryStringDecoder queryDecoder = new QueryStringDecoder(req.uri());
                String requestPath = queryDecoder.path();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received HTTP {} handshake request: {} from channel: {}", new Object[]{this.getTransportType().getName(), req, ctx.channel()});
                }
                try {
                    this.handshake(ctx, req, requestPath);
                }
                catch (Exception e) {
                    this.log.error("Error during {} handshake : {}", (Object)this.getTransportType().getName(), (Object)e);
                }
                finally {
                    ReferenceCountUtil.release((Object)msg);
                }
                return;
            }
        } else if (msg instanceof WebSocketFrame && this.isCurrentHandlerSession(ctx)) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
            return;
        }
        ctx.fireChannelRead(msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.sessionIdByChannel.remove(ctx.channel());
        super.channelInactive(ctx);
    }

    private boolean isCurrentHandlerSession(ChannelHandlerContext ctx) {
        return this.sessionIdByChannel.containsKey(ctx.channel());
    }

    private void handshake(final ChannelHandlerContext ctx, final FullHttpRequest req, final String requestPath) {
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation((HttpRequest)req), null, true, this.maxWebSocketFrameSize);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker((HttpRequest)req);
        if (handshaker != null) {
            handshaker.handshake(ctx.channel(), req).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    String sessionId = PipelineUtils.getSessionId(requestPath);
                    if (future.isSuccess()) {
                        ctx.channel().pipeline().addBefore("socketio-websocket-handler", "websocket-frame-aggregator", (ChannelHandler)new WebSocketFrameAggregator(WebSocketHandler.this.maxWebSocketFrameSize));
                        WebSocketHandler.this.connect(ctx, (HttpRequest)req, sessionId);
                    } else {
                        WebSocketHandler.this.log.error("Can't handshake: {}", (Object)sessionId, (Object)future.cause());
                    }
                }
            });
        } else {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        }
    }

    private String getWebSocketLocation(HttpRequest req) {
        String protocol = this.secure ? "wss://" : "ws://";
        String webSocketLocation = protocol + req.headers().get((CharSequence)HttpHeaderNames.HOST) + req.uri();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created {} at: {}", (Object)this.getTransportType().getName(), (Object)webSocketLocation);
        }
        return webSocketLocation;
    }

    private void connect(ChannelHandlerContext ctx, HttpRequest req, String sessionId) throws Exception {
        this.sessionIdByChannel.put(ctx.channel(), sessionId);
        SocketAddress clientIp = PipelineUtils.resolveClientIpByRemoteAddressHeader((HttpMessage)req, this.remoteAddressHeader);
        ConnectPacket packet = new ConnectPacket(sessionId, PipelineUtils.getOrigin(req));
        packet.setTransportType(this.getTransportType());
        packet.setRemoteAddress(clientIp);
        ctx.fireChannelRead((Object)packet);
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame msg) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received {} WebSocketFrame: {} from channel: {}", new Object[]{this.getTransportType().getName(), msg, ctx.channel()});
        }
        if (msg instanceof CloseWebSocketFrame) {
            this.sessionIdByChannel.remove(ctx.channel());
            ChannelFuture f = ctx.writeAndFlush((Object)msg);
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else if (msg instanceof PingWebSocketFrame) {
            ctx.writeAndFlush((Object)new PongWebSocketFrame(msg.content()));
        } else if (msg instanceof TextWebSocketFrame || msg instanceof BinaryWebSocketFrame) {
            Packet packet = PacketDecoder.decodePacket(msg.content());
            packet.setTransportType(this.getTransportType());
            String sessionId = this.sessionIdByChannel.get(ctx.channel());
            packet.setSessionId(sessionId);
            msg.release();
            ctx.fireChannelRead((Object)packet);
        } else {
            msg.release();
            this.log.warn("{} frame type is not supported", (Object)msg.getClass().getName());
        }
    }
}

