/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.serialization;

import io.netty.buffer.ByteBuf;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import io.scalecube.socketio.packets.Packet;
import io.scalecube.socketio.packets.PacketType;
import java.io.IOException;

public final class PacketDecoder {
    private static final byte DELIMITER = 58;
    private static final ByteProcessor packetDelimiterFinder = new ByteProcessor(){

        public boolean process(byte value) throws Exception {
            return value != 58;
        }
    };

    private PacketDecoder() {
    }

    public static Packet decodePacket(ByteBuf payload) throws IOException {
        int dataLength;
        boolean messagingType;
        int payloadSize = payload.readableBytes();
        int typeDelimiterIndex = payload.forEachByte(packetDelimiterFinder);
        if (typeDelimiterIndex == -1) {
            return Packet.NULL_INSTANCE;
        }
        ByteBuf typeBytes = payload.slice(0, typeDelimiterIndex);
        String typeString = typeBytes.toString(CharsetUtil.UTF_8);
        int typeId = Integer.valueOf(typeString);
        PacketType type = PacketType.valueOf(typeId);
        int messageIdDelimiterIndex = payload.forEachByte(typeDelimiterIndex + 1, payloadSize - typeDelimiterIndex - 1, packetDelimiterFinder);
        if (messageIdDelimiterIndex == -1) {
            return Packet.NULL_INSTANCE;
        }
        int endpointDelimiterIndex = payload.forEachByte(messageIdDelimiterIndex + 1, payloadSize - messageIdDelimiterIndex - 1, packetDelimiterFinder);
        Packet packet = new Packet(type);
        boolean bl = messagingType = type == PacketType.MESSAGE || type == PacketType.JSON;
        if (endpointDelimiterIndex != -1 && messagingType && (dataLength = payloadSize - endpointDelimiterIndex - 1) > 0) {
            ByteBuf data = payload.copy(endpointDelimiterIndex + 1, dataLength);
            packet.setData(data);
        }
        return packet;
    }
}

