/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.serialization;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.CharsetUtil;
import io.scalecube.socketio.packets.Packet;
import java.io.IOException;

public final class PacketEncoder {
    private static final String DELIMITER = ":";
    private static final byte[] DELIMITER_BYTES = ":".getBytes(CharsetUtil.UTF_8);
    private static final int DELIMITER_LENGTH = DELIMITER_BYTES.length;

    private PacketEncoder() {
    }

    public static ByteBuf encodePacket(Packet packet) throws IOException {
        ByteBuf dataBytes = packet.getData();
        boolean hasData = dataBytes != null;
        CompositeByteBuf compositeByteBuf = PooledByteBufAllocator.DEFAULT.compositeBuffer(hasData ? 1 : 2);
        byte[] typeBytes = packet.getType().getValueAsBytes();
        int headerCapacity = typeBytes.length + DELIMITER_LENGTH + DELIMITER_LENGTH + (hasData ? DELIMITER_LENGTH : 0);
        ByteBuf headerByteBuf = PooledByteBufAllocator.DEFAULT.buffer(headerCapacity, headerCapacity);
        headerByteBuf.writeBytes(typeBytes);
        headerByteBuf.writeBytes(DELIMITER_BYTES);
        headerByteBuf.writeBytes(DELIMITER_BYTES);
        if (hasData) {
            headerByteBuf.writeBytes(DELIMITER_BYTES);
        }
        compositeByteBuf.addComponent(headerByteBuf);
        int compositeReadableBytes = headerByteBuf.readableBytes();
        if (hasData) {
            compositeByteBuf.addComponent(dataBytes);
            compositeReadableBytes += dataBytes.readableBytes();
        }
        compositeByteBuf.writerIndex(compositeReadableBytes);
        return compositeByteBuf;
    }
}

