/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.serialization;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.CharsetUtil;
import io.scalecube.socketio.packets.Packet;
import io.scalecube.socketio.packets.PacketsFrame;
import io.scalecube.socketio.serialization.PacketDecoder;
import io.scalecube.socketio.serialization.PacketEncoder;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public final class PacketFramer {
    private static final char DELIMITER = '\ufffd';
    private static final byte[] DELIMITER_BYTES = new String(new char[]{'\ufffd'}).getBytes(CharsetUtil.UTF_8);
    private static final int DELIMITER_BYTES_SIZE = DELIMITER_BYTES.length;

    private PacketFramer() {
    }

    public static ByteBuf encodePacketsFrame(PacketsFrame packetsFrame) throws IOException {
        List<Packet> packets = packetsFrame.getPackets();
        if (packets.size() == 1) {
            Packet packet = packets.get(0);
            return PacketEncoder.encodePacket(packet);
        }
        CompositeByteBuf compositeByteBuf = PooledByteBufAllocator.DEFAULT.compositeBuffer(packets.size() * 2);
        int compositeReadableBytes = 0;
        for (Packet packet : packets) {
            ByteBuf packetByteBuf = PacketEncoder.encodePacket(packet);
            int packetLength = PacketFramer.getUtf8CharCountByByteCount(packetByteBuf, 0, packetByteBuf.readableBytes());
            byte[] packetLengthBytes = String.valueOf(packetLength).getBytes(CharsetUtil.UTF_8);
            int packetLengthPrependerCapacity = packetLengthBytes.length + DELIMITER_BYTES_SIZE + DELIMITER_BYTES_SIZE;
            ByteBuf packetLengthPrependerByteBuf = PooledByteBufAllocator.DEFAULT.buffer(packetLengthPrependerCapacity, packetLengthPrependerCapacity);
            packetLengthPrependerByteBuf.writeBytes(DELIMITER_BYTES);
            packetLengthPrependerByteBuf.writeBytes(packetLengthBytes);
            packetLengthPrependerByteBuf.writeBytes(DELIMITER_BYTES);
            compositeByteBuf.addComponent(packetLengthPrependerByteBuf);
            compositeByteBuf.addComponent(packetByteBuf);
            compositeReadableBytes += packetLengthPrependerByteBuf.readableBytes() + packetByteBuf.readableBytes();
        }
        compositeByteBuf.writerIndex(compositeReadableBytes);
        return compositeByteBuf;
    }

    private static int getUtf8CharCountByByteCount(ByteBuf buffer, int startByteIndex, int bytesCount) {
        int charCount = 0;
        int endByteIndex = startByteIndex + bytesCount;
        int byteIndex = startByteIndex;
        while (byteIndex < endByteIndex) {
            ++charCount;
            short charFirstByte = buffer.getUnsignedByte(byteIndex);
            if (charFirstByte >= 32 && charFirstByte <= 127) {
                ++byteIndex;
                continue;
            }
            if ((charFirstByte & 0xE0) == 192) {
                byteIndex += 2;
                continue;
            }
            if ((charFirstByte & 0xF0) == 224) {
                byteIndex += 3;
                continue;
            }
            if ((charFirstByte & 0xF8) == 240) {
                byteIndex += 4;
                continue;
            }
            if ((charFirstByte & 0xFC) == 248) {
                byteIndex += 5;
                continue;
            }
            if ((charFirstByte & 0xFE) == 252) {
                byteIndex += 6;
                continue;
            }
            ++byteIndex;
        }
        return charCount;
    }

    public static List<Packet> decodePacketsFrame(ByteBuf buffer) throws IOException {
        LinkedList<Packet> packets = new LinkedList<Packet>();
        int sequenceNumber = 0;
        while (buffer.isReadable()) {
            Packet packet = PacketFramer.decodeNextPacket(buffer);
            packet.setSequenceNumber(sequenceNumber);
            ++sequenceNumber;
            packets.add(packet);
        }
        return packets;
    }

    private static Packet decodeNextPacket(ByteBuf buffer) throws IOException {
        Packet packet;
        if (PacketFramer.isDelimiter(buffer, buffer.readerIndex())) {
            CharSequence packetCharsCountString = PacketFramer.decodePacketLength(buffer);
            Integer packetCharsCount = Integer.valueOf(packetCharsCountString.toString());
            int packetStartIndex = buffer.readerIndex() + DELIMITER_BYTES_SIZE + packetCharsCountString.length() + DELIMITER_BYTES_SIZE;
            int packetBytesCount = PacketFramer.getUtf8ByteCountByCharCount(buffer, packetStartIndex, packetCharsCount);
            ByteBuf frame = buffer.slice(packetStartIndex, packetBytesCount);
            packet = PacketDecoder.decodePacket(frame);
            buffer.readerIndex(packetStartIndex + packetBytesCount);
        } else {
            packet = PacketDecoder.decodePacket(buffer);
            buffer.readerIndex(buffer.readableBytes());
        }
        return packet;
    }

    private static int getUtf8ByteCountByCharCount(ByteBuf buffer, int startIndex, int charCount) {
        int bytesCount = 0;
        for (int charIndex = 0; charIndex < charCount; ++charIndex) {
            int charFirstByteIndex = startIndex + bytesCount;
            short charFirstByte = buffer.getUnsignedByte(charFirstByteIndex);
            if (charFirstByte >= 32 && charFirstByte <= 127) {
                ++bytesCount;
                continue;
            }
            if ((charFirstByte & 0xE0) == 192) {
                bytesCount += 2;
                continue;
            }
            if ((charFirstByte & 0xF0) == 224) {
                bytesCount += 3;
                continue;
            }
            if ((charFirstByte & 0xF8) == 240) {
                bytesCount += 4;
                continue;
            }
            if ((charFirstByte & 0xFC) == 248) {
                bytesCount += 5;
                continue;
            }
            if ((charFirstByte & 0xFE) == 252) {
                bytesCount += 6;
                continue;
            }
            ++bytesCount;
        }
        return bytesCount;
    }

    private static CharSequence decodePacketLength(ByteBuf buffer) {
        StringBuilder length = new StringBuilder();
        int scanStartIndex = buffer.readerIndex() + DELIMITER_BYTES_SIZE;
        int scanEndIndex = buffer.readerIndex() + buffer.readableBytes();
        for (int charIndex = scanStartIndex; charIndex < scanEndIndex && !PacketFramer.isDelimiter(buffer, charIndex); ++charIndex) {
            length.append((char)buffer.getUnsignedByte(charIndex));
        }
        return length;
    }

    private static boolean isDelimiter(ByteBuf buffer, int index) {
        for (int i = 0; i < DELIMITER_BYTES_SIZE; ++i) {
            if (buffer.getByte(index + i) == DELIMITER_BYTES[i]) continue;
            return false;
        }
        return true;
    }
}

