/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.session;

import io.netty.channel.Channel;
import io.scalecube.socketio.Session;
import io.scalecube.socketio.TransportType;
import io.scalecube.socketio.packets.Packet;
import io.scalecube.socketio.packets.PacketType;
import io.scalecube.socketio.packets.PacketsFrame;
import io.scalecube.socketio.session.AbstractSession;
import io.scalecube.socketio.session.PollingQueue;
import io.scalecube.socketio.session.SessionDisconnectHandler;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractPollingSession
extends AbstractSession {
    private final Packet ackPacket = new Packet(PacketType.ACK);
    private final PollingQueue messagesQueue = new PollingQueue();
    private final AtomicReference<Channel> outChannelHolder = new AtomicReference();

    public AbstractPollingSession(Channel channel, String sessionId, String origin, SessionDisconnectHandler disconnectHandler, TransportType upgradedFromTransportType, int localPort, SocketAddress remoteAddress) {
        super(channel, sessionId, origin, disconnectHandler, upgradedFromTransportType, localPort, remoteAddress);
    }

    @Override
    public boolean connect(Channel channel) {
        boolean initialConnect = super.connect(channel);
        if (!initialConnect) {
            this.bindChannel(channel);
        }
        return initialConnect;
    }

    private void bindChannel(Channel channel) {
        if (this.getState() == Session.State.DISCONNECTING) {
            this.disconnect(channel);
        } else {
            this.flush(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(Channel channel) {
        PollingQueue pollingQueue = this.messagesQueue;
        synchronized (pollingQueue) {
            if (this.messagesQueue.isEmpty()) {
                this.outChannelHolder.set(channel);
            } else {
                PacketsFrame packetsFrame = this.messagesQueue.takeAll();
                this.sendPacketToChannel(channel, packetsFrame);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPacket(Packet packet) {
        if (packet == null) {
            throw new IllegalArgumentException("Packet is null");
        }
        Channel channel = this.outChannelHolder.getAndSet(null);
        if (channel != null && channel.isActive()) {
            this.sendPacketToChannel(channel, packet);
        } else {
            PollingQueue pollingQueue = this.messagesQueue;
            synchronized (pollingQueue) {
                this.messagesQueue.add(packet);
            }
        }
    }

    @Override
    public void disconnect() {
        if (this.getState() == Session.State.DISCONNECTED) {
            return;
        }
        if (this.getState() != Session.State.DISCONNECTING) {
            this.setState(Session.State.DISCONNECTING);
            Channel channel = this.outChannelHolder.getAndSet(null);
            if (channel != null && channel.isActive()) {
                this.disconnect(channel);
            } else {
                this.heartbeatScheduler.scheduleDisconnect();
            }
        } else {
            this.disconnect(null);
        }
    }

    @Override
    public void acceptPacket(Channel channel, Packet packet) {
        if (packet.getSequenceNumber() == 0) {
            this.sendPacketToChannel(channel, this.ackPacket);
        }
    }
}

