/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.session;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.scalecube.socketio.Session;
import io.scalecube.socketio.TransportType;
import io.scalecube.socketio.packets.IPacket;
import io.scalecube.socketio.packets.Packet;
import io.scalecube.socketio.packets.PacketType;
import io.scalecube.socketio.session.ManagedSession;
import io.scalecube.socketio.session.SessionDisconnectHandler;
import io.scalecube.socketio.session.SocketIOHeartbeatScheduler;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSession
implements ManagedSession {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String sessionId;
    private final String origin;
    private final SocketAddress remoteAddress;
    private final TransportType upgradedFromTransportType;
    private final int localPort;
    private final Packet connectPacket = new Packet(PacketType.CONNECT);
    private final Packet disconnectPacket = new Packet(PacketType.DISCONNECT);
    private final Packet heartbeatPacket = new Packet(PacketType.HEARTBEAT);
    protected final SessionDisconnectHandler disconnectHandler;
    protected final SocketIOHeartbeatScheduler heartbeatScheduler;
    private final AtomicReference<Session.State> stateHolder = new AtomicReference<Session.State>(Session.State.CREATED);
    private volatile boolean upgraded = false;

    public AbstractSession(Channel channel, String sessionId, String origin, SessionDisconnectHandler disconnectHandler, TransportType upgradedFromTransportType, int localPort, SocketAddress remoteAddress) {
        this.sessionId = sessionId;
        this.remoteAddress = remoteAddress == null ? channel.remoteAddress() : remoteAddress;
        this.origin = origin;
        this.localPort = localPort;
        this.disconnectHandler = disconnectHandler;
        this.upgradedFromTransportType = upgradedFromTransportType;
        this.heartbeatScheduler = new SocketIOHeartbeatScheduler(this);
        this.setState(Session.State.CONNECTING);
    }

    @Override
    public final String getSessionId() {
        return this.sessionId;
    }

    @Override
    public final boolean isUpgradedSession() {
        return this.upgradedFromTransportType != null;
    }

    @Override
    public TransportType getUpgradedFromTransportType() {
        return this.upgradedFromTransportType;
    }

    @Override
    public final SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public final String getOrigin() {
        return this.origin;
    }

    @Override
    public int getLocalPort() {
        return this.localPort;
    }

    protected boolean isUpgraded() {
        return this.upgraded;
    }

    @Override
    public Session.State getState() {
        return this.stateHolder.get();
    }

    @Override
    public boolean connect(Channel channel) {
        boolean initialConnect;
        this.heartbeatScheduler.reschedule();
        Session.State previousState = this.setState(Session.State.CONNECTED);
        boolean bl = initialConnect = previousState == Session.State.CONNECTING;
        if (initialConnect) {
            this.sendPacketToChannel(channel, this.connectPacket);
        }
        return initialConnect;
    }

    @Override
    public void disconnect(Channel channel) {
        if (this.getState() == Session.State.DISCONNECTED) {
            return;
        }
        this.setState(Session.State.DISCONNECTING);
        this.heartbeatScheduler.disableHeartbeat();
        if (!this.isUpgraded()) {
            this.sendPacket(this.disconnectPacket);
            this.disconnectHandler.onSessionDisconnect(this);
        }
        this.setState(Session.State.DISCONNECTED);
    }

    @Override
    public void sendHeartbeat() {
        this.sendPacket(this.heartbeatPacket);
    }

    @Override
    public void send(ByteBuf message) {
        Packet messagePacket = new Packet(PacketType.MESSAGE);
        messagePacket.setData(message);
        this.sendPacket(messagePacket);
    }

    protected void sendPacketToChannel(Channel channel, IPacket packet) {
        this.fillPacketHeaders(packet);
        channel.writeAndFlush((Object)packet);
    }

    @Override
    public void acceptPacket(Channel channel, Packet packet) {
    }

    @Override
    public void markAsUpgraded() {
        this.upgraded = true;
    }

    @Override
    public void acceptHeartbeat() {
        this.heartbeatScheduler.reschedule();
    }

    protected void fillPacketHeaders(IPacket packet) {
        packet.setOrigin(this.getOrigin());
        packet.setSessionId(this.getSessionId());
        packet.setTransportType(this.getTransportType());
    }

    protected Session.State setState(Session.State state) {
        Session.State previousState = this.stateHolder.getAndSet(state);
        if (previousState != state && this.log.isDebugEnabled()) {
            this.log.debug("Session {} state changed from {} to {}", new Object[]{this.getSessionId(), previousState, state});
        }
        return previousState;
    }

    public String toString() {
        return "[id: " + this.getSessionId() + ", origin: " + this.getOrigin() + ", addr: " + this.getRemoteAddress() + ", bindPort: " + this.getLocalPort() + ", transport: " + (Object)((Object)this.getTransportType()) + (this.isUpgradedSession() ? ", upgradedFrom: " + (Object)((Object)this.getUpgradedFromTransportType()) : "") + ']';
    }
}

