/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.session;

import io.netty.channel.Channel;
import io.scalecube.socketio.TransportType;
import io.scalecube.socketio.packets.ConnectPacket;
import io.scalecube.socketio.pipeline.UnsupportedTransportTypeException;
import io.scalecube.socketio.session.FlashSocketSession;
import io.scalecube.socketio.session.JsonpPollingSession;
import io.scalecube.socketio.session.ManagedSession;
import io.scalecube.socketio.session.SessionDisconnectHandler;
import io.scalecube.socketio.session.WebSocketSession;
import io.scalecube.socketio.session.XHRPollingSession;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<String, ManagedSession> sessions = new ConcurrentHashMap<String, ManagedSession>();
    private final int localPort;

    public SessionStorage(int localPort) {
        this.localPort = localPort;
    }

    public boolean containSession(String sessionId) {
        return this.sessions.containsKey(sessionId);
    }

    public void removeSession(String sessionId) {
        this.sessions.remove(sessionId);
    }

    public ManagedSession getSession(ConnectPacket connectPacket, Channel channel, SessionDisconnectHandler disconnectHandler) throws Exception {
        ManagedSession session = this.getOrCreateSession(connectPacket, channel, disconnectHandler, null);
        if (connectPacket.getTransportType() != session.getTransportType()) {
            session.markAsUpgraded();
            String oldSessionId = session.getSessionId();
            TransportType oldTransportType = session.getTransportType();
            String sessionId = connectPacket.getSessionId();
            this.removeSession(sessionId);
            session = this.getOrCreateSession(connectPacket, channel, disconnectHandler, session.getTransportType());
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} transport type {} session was upgraded to new transport type {} and session {}", new Object[]{oldTransportType.name(), oldSessionId, session.getTransportType().name(), session.getSessionId()});
            }
        }
        return session;
    }

    private ManagedSession getOrCreateSession(ConnectPacket connectPacket, Channel channel, SessionDisconnectHandler disconnectHandler, TransportType upgradedFromTransportType) throws Exception {
        ManagedSession fasterSession;
        String sessionId = connectPacket.getSessionId();
        ManagedSession session = (ManagedSession)this.sessions.get(sessionId);
        if (session == null && (fasterSession = this.sessions.putIfAbsent(sessionId, session = this.createSession(connectPacket, channel, disconnectHandler, upgradedFromTransportType))) != null) {
            session = fasterSession;
        }
        return session;
    }

    private ManagedSession createSession(ConnectPacket connectPacket, Channel channel, SessionDisconnectHandler disconnectHandler, TransportType upgradedFromTransportType) throws Exception {
        TransportType transportType = connectPacket.getTransportType();
        String sessionId = connectPacket.getSessionId();
        String origin = connectPacket.getOrigin();
        String jsonpIndexParam = connectPacket.getJsonpIndexParam();
        SocketAddress remoteAddress = connectPacket.getRemoteAddress();
        switch (transportType) {
            case WEBSOCKET: {
                return new WebSocketSession(channel, sessionId, origin, disconnectHandler, upgradedFromTransportType, this.localPort, remoteAddress);
            }
            case FLASHSOCKET: {
                return new FlashSocketSession(channel, sessionId, origin, disconnectHandler, upgradedFromTransportType, this.localPort, remoteAddress);
            }
            case XHR_POLLING: {
                return new XHRPollingSession(channel, sessionId, origin, disconnectHandler, upgradedFromTransportType, this.localPort, remoteAddress);
            }
            case JSONP_POLLING: {
                return new JsonpPollingSession(channel, sessionId, origin, disconnectHandler, upgradedFromTransportType, this.localPort, jsonpIndexParam, remoteAddress);
            }
        }
        throw new UnsupportedTransportTypeException(transportType);
    }

    public ManagedSession getSessionIfExist(String sessionId) {
        return (ManagedSession)this.sessions.get(sessionId);
    }
}

