/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.socketio.session;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.scalecube.socketio.session.ManagedSession;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketIOHeartbeatScheduler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static int heartbeatInterval;
    private static int heartbeatTimeout;
    private static HashedWheelTimer hashedWheelTimer;
    private Timeout hTimeout = null;
    private Timeout dTimeout = null;
    private final ManagedSession session;
    private volatile boolean disabled = false;

    public SocketIOHeartbeatScheduler(ManagedSession session) {
        this.session = session;
    }

    public static void setHashedWheelTimer(HashedWheelTimer hashedWheelTimer) {
        SocketIOHeartbeatScheduler.hashedWheelTimer = hashedWheelTimer;
    }

    public static void setHeartbeatInterval(int heartbeatInterval) {
        SocketIOHeartbeatScheduler.heartbeatInterval = heartbeatInterval;
    }

    public static void setHeartbeatTimeout(int heartbeatTimeout) {
        SocketIOHeartbeatScheduler.heartbeatTimeout = heartbeatTimeout;
    }

    public void reschedule() {
        if (!this.disabled) {
            this.cancelDisconnect();
            this.cancelHeartbeat();
            this.scheduleHeartbeat();
            this.scheduleDisconnect();
        }
    }

    private void cancelHeartbeat() {
        if (this.hTimeout != null && !this.hTimeout.isCancelled()) {
            this.hTimeout.cancel();
        }
    }

    private void cancelDisconnect() {
        if (this.dTimeout != null && !this.dTimeout.isCancelled()) {
            this.dTimeout.cancel();
        }
    }

    public void disableHeartbeat() {
        this.disabled = true;
    }

    private void scheduleHeartbeat() {
        this.hTimeout = hashedWheelTimer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                if (!SocketIOHeartbeatScheduler.this.disabled) {
                    SocketIOHeartbeatScheduler.this.session.sendHeartbeat();
                    SocketIOHeartbeatScheduler.this.scheduleHeartbeat();
                }
            }
        }, (long)heartbeatInterval, TimeUnit.SECONDS);
    }

    public void scheduleDisconnect() {
        this.dTimeout = hashedWheelTimer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                if (!SocketIOHeartbeatScheduler.this.disabled) {
                    if (SocketIOHeartbeatScheduler.this.log.isDebugEnabled()) {
                        SocketIOHeartbeatScheduler.this.log.debug("{} Session will be disconnected by timeout", (Object)SocketIOHeartbeatScheduler.this.session.getSessionId());
                    }
                    SocketIOHeartbeatScheduler.this.session.disconnect();
                }
            }
        }, (long)heartbeatTimeout, TimeUnit.SECONDS);
    }
}

