/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.auth.principal.ParseException;
import java.io.IOException;
import java.util.function.Function;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.annotations.Pos;
import org.jboss.logging.annotations.Producer;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.lang.UnresolvableKeyException;

@MessageBundle(projectCode="SRJWT", length=5)
interface PrincipalMessages {
    public static final PrincipalMessages msg = (PrincipalMessages)Messages.getBundle(PrincipalMessages.class);

    @Message(id=7000, value="Failed to verify a token")
    public ParseException failedToVerifyToken(@Cause Throwable var1);

    @Message(id=7001, value="No claim exists in sub, upn or preferred_username")
    public InvalidJwtException claimNotFound(@Producer Function<String, InvalidJwtException> var1);

    @Message(id=7002, value="Failed to load a key from the key content")
    public UnresolvableKeyException failedToLoadKey(@Cause Throwable var1);

    @Message(id=7003, value="Failed to load a key from %s")
    public UnresolvableKeyException failedToLoadKeyFromLocation(@Pos(value={1}) String var1, @Cause Throwable var2);

    @Message(id=7004, value="Failed to load a key from the key content while resolving")
    public UnresolvableKeyException failedToLoadKeyWhileResolving();

    @Message(id=7005, value="Failed to load a key from %s property while resolving")
    public UnresolvableKeyException failedToLoadKeyFromLocationWhileResolving(@Pos(value={1}) String var1);

    @Message(id=7006, value="Invalid token 'kid' header")
    public UnresolvableKeyException invalidTokenKid();

    @Message(id=7007, value="No resource with the named %s location exists")
    public IOException resourceNotFound(String var1);

    @Message(id=7008, value="Failed to verify max TTL")
    public ParseException failedToVerifyMaxTTL(@Cause Throwable var1);

    @Message(id=7009, value="The Expiration Time (exp=%s) claim value cannot be more than %d seconds in the future relative to Issued At (iat=%s)")
    public ParseException expExceeded(NumericDate var1, long var2, NumericDate var4);

    @Message(id=7010, value="Required claims are not present in the JWT")
    public InvalidJwtException missingClaims(@Producer Function<String, InvalidJwtException> var1);

    @Message(id=7011, value="Verification key is unresolvable")
    public ParseException verificationKeyUnresolvable();

    @Message(id=7012, value="Decryption key is unresolvable")
    public ParseException decryptionKeyUnresolvable(@Cause Throwable var1);

    @Message(id=7013, value="Encrypted token sequence is invalid")
    public ParseException encryptedTokenSequenceInvalid(@Cause Throwable var1);

    @Message(id=7014, value="Failed to load X509 certificates")
    public ParseException failedToLoadCertificates();
}

