/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.javascript;

import com.meterware.httpunit.ClientProperties;
import com.meterware.httpunit.HTMLPage;
import com.meterware.httpunit.ScriptException;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebImage;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.javascript.RhinoException;
import com.meterware.httpunit.scripting.DocumentElement;
import com.meterware.httpunit.scripting.IdentifiedDelegate;
import com.meterware.httpunit.scripting.Input;
import com.meterware.httpunit.scripting.NamedDelegate;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import com.meterware.httpunit.scripting.ScriptingEngine;
import com.meterware.httpunit.scripting.SelectionOption;
import com.meterware.httpunit.scripting.SelectionOptions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import org.mozilla.javascript.ClassDefinitionException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NotAFunctionException;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.xml.sax.SAXException;

public class JavaScript {
    private static final Object[] NO_ARGS = new Object[0];
    private static boolean _throwExceptionsOnError = true;
    private static ArrayList _errorMessages = new ArrayList();
    static /* synthetic */ Class class$com$meterware$httpunit$javascript$JavaScript$Window;
    static /* synthetic */ Class class$com$meterware$httpunit$javascript$JavaScript$Document;
    static /* synthetic */ Class class$com$meterware$httpunit$javascript$JavaScript$Location;
    static /* synthetic */ Class class$com$meterware$httpunit$javascript$JavaScript$Navigator;
    static /* synthetic */ Class class$com$meterware$httpunit$javascript$JavaScript$Screen;
    static /* synthetic */ Class class$com$meterware$httpunit$javascript$JavaScript$Link;
    static /* synthetic */ Class class$com$meterware$httpunit$javascript$JavaScript$Form;
    static /* synthetic */ Class class$com$meterware$httpunit$javascript$JavaScript$Control;
    static /* synthetic */ Class class$com$meterware$httpunit$javascript$JavaScript$Image;
    static /* synthetic */ Class class$com$meterware$httpunit$javascript$JavaScript$Options;
    static /* synthetic */ Class class$com$meterware$httpunit$javascript$JavaScript$Option;
    static /* synthetic */ Class class$com$meterware$httpunit$javascript$JavaScript$ElementArray;
    static /* synthetic */ Class class$com$meterware$httpunit$javascript$JavaScript$HTMLElement;

    static boolean isThrowExceptionsOnError() {
        return _throwExceptionsOnError;
    }

    static void setThrowExceptionsOnError(boolean throwExceptionsOnError) {
        _throwExceptionsOnError = throwExceptionsOnError;
    }

    static void clearErrorMessages() {
        _errorMessages.clear();
    }

    static String[] getErrorMessages() {
        return _errorMessages.toArray(new String[_errorMessages.size()]);
    }

    static void run(WebResponse response) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, NotAFunctionException, PropertyException, SAXException, JavaScriptException {
        Context context = Context.enter();
        Scriptable scope = context.initStandardObjects(null);
        JavaScript.initHTMLObjects(scope);
        Window w = (Window)context.newObject(scope, "Window");
        w.initialize(null, response.getScriptableObject());
    }

    private static void initHTMLObjects(Scriptable scope) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        ScriptableObject.defineClass((Scriptable)scope, (Class)(class$com$meterware$httpunit$javascript$JavaScript$Window == null ? (class$com$meterware$httpunit$javascript$JavaScript$Window = JavaScript.class$("com.meterware.httpunit.javascript.JavaScript$Window")) : class$com$meterware$httpunit$javascript$JavaScript$Window));
        ScriptableObject.defineClass((Scriptable)scope, (Class)(class$com$meterware$httpunit$javascript$JavaScript$Document == null ? (class$com$meterware$httpunit$javascript$JavaScript$Document = JavaScript.class$("com.meterware.httpunit.javascript.JavaScript$Document")) : class$com$meterware$httpunit$javascript$JavaScript$Document));
        ScriptableObject.defineClass((Scriptable)scope, (Class)(class$com$meterware$httpunit$javascript$JavaScript$Location == null ? (class$com$meterware$httpunit$javascript$JavaScript$Location = JavaScript.class$("com.meterware.httpunit.javascript.JavaScript$Location")) : class$com$meterware$httpunit$javascript$JavaScript$Location));
        ScriptableObject.defineClass((Scriptable)scope, (Class)(class$com$meterware$httpunit$javascript$JavaScript$Navigator == null ? (class$com$meterware$httpunit$javascript$JavaScript$Navigator = JavaScript.class$("com.meterware.httpunit.javascript.JavaScript$Navigator")) : class$com$meterware$httpunit$javascript$JavaScript$Navigator));
        ScriptableObject.defineClass((Scriptable)scope, (Class)(class$com$meterware$httpunit$javascript$JavaScript$Screen == null ? (class$com$meterware$httpunit$javascript$JavaScript$Screen = JavaScript.class$("com.meterware.httpunit.javascript.JavaScript$Screen")) : class$com$meterware$httpunit$javascript$JavaScript$Screen));
        ScriptableObject.defineClass((Scriptable)scope, (Class)(class$com$meterware$httpunit$javascript$JavaScript$Link == null ? (class$com$meterware$httpunit$javascript$JavaScript$Link = JavaScript.class$("com.meterware.httpunit.javascript.JavaScript$Link")) : class$com$meterware$httpunit$javascript$JavaScript$Link));
        ScriptableObject.defineClass((Scriptable)scope, (Class)(class$com$meterware$httpunit$javascript$JavaScript$Form == null ? (class$com$meterware$httpunit$javascript$JavaScript$Form = JavaScript.class$("com.meterware.httpunit.javascript.JavaScript$Form")) : class$com$meterware$httpunit$javascript$JavaScript$Form));
        ScriptableObject.defineClass((Scriptable)scope, (Class)(class$com$meterware$httpunit$javascript$JavaScript$Control == null ? (class$com$meterware$httpunit$javascript$JavaScript$Control = JavaScript.class$("com.meterware.httpunit.javascript.JavaScript$Control")) : class$com$meterware$httpunit$javascript$JavaScript$Control));
        ScriptableObject.defineClass((Scriptable)scope, (Class)(class$com$meterware$httpunit$javascript$JavaScript$Link == null ? (class$com$meterware$httpunit$javascript$JavaScript$Link = JavaScript.class$("com.meterware.httpunit.javascript.JavaScript$Link")) : class$com$meterware$httpunit$javascript$JavaScript$Link));
        ScriptableObject.defineClass((Scriptable)scope, (Class)(class$com$meterware$httpunit$javascript$JavaScript$Image == null ? (class$com$meterware$httpunit$javascript$JavaScript$Image = JavaScript.class$("com.meterware.httpunit.javascript.JavaScript$Image")) : class$com$meterware$httpunit$javascript$JavaScript$Image));
        ScriptableObject.defineClass((Scriptable)scope, (Class)(class$com$meterware$httpunit$javascript$JavaScript$Options == null ? (class$com$meterware$httpunit$javascript$JavaScript$Options = JavaScript.class$("com.meterware.httpunit.javascript.JavaScript$Options")) : class$com$meterware$httpunit$javascript$JavaScript$Options));
        ScriptableObject.defineClass((Scriptable)scope, (Class)(class$com$meterware$httpunit$javascript$JavaScript$Option == null ? (class$com$meterware$httpunit$javascript$JavaScript$Option = JavaScript.class$("com.meterware.httpunit.javascript.JavaScript$Option")) : class$com$meterware$httpunit$javascript$JavaScript$Option));
        ScriptableObject.defineClass((Scriptable)scope, (Class)(class$com$meterware$httpunit$javascript$JavaScript$ElementArray == null ? (class$com$meterware$httpunit$javascript$JavaScript$ElementArray = JavaScript.class$("com.meterware.httpunit.javascript.JavaScript$ElementArray")) : class$com$meterware$httpunit$javascript$JavaScript$ElementArray));
        ScriptableObject.defineClass((Scriptable)scope, (Class)(class$com$meterware$httpunit$javascript$JavaScript$HTMLElement == null ? (class$com$meterware$httpunit$javascript$JavaScript$HTMLElement = JavaScript.class$("com.meterware.httpunit.javascript.JavaScript$HTMLElement")) : class$com$meterware$httpunit$javascript$JavaScript$HTMLElement));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Option
    extends JavaScriptEngine {
        public String getClassName() {
            return "Option";
        }

        public void jsConstructor(String text, String value, boolean defaultSelected, boolean selected) {
            this._scriptable = WebResponse.newDelegate("Option");
            this.getDelegate().initialize(text, value, defaultSelected, selected);
        }

        public int jsGet_index() {
            return this.getDelegate().getIndex();
        }

        public String jsGet_text() {
            return this.getDelegate().getText();
        }

        public void jsSet_text(String text) {
            this.getDelegate().setText(text);
        }

        public String jsGet_value() {
            return this.getDelegate().getValue();
        }

        public void jsSet_value(String value) {
            this.getDelegate().setValue(value);
        }

        public boolean jsGet_selected() {
            return this.getDelegate().isSelected();
        }

        public void jsSet_selected(boolean selected) {
            this.getDelegate().setSelected(selected);
        }

        public boolean jsGet_defaultSelected() {
            return this.getDelegate().isDefaultSelected();
        }

        SelectionOption getDelegate() {
            return (SelectionOption)((Object)this._scriptable);
        }
    }

    public static class Options
    extends JavaScriptEngine {
        public String getClassName() {
            return "Options";
        }

        public int jsGet_length() {
            return this.getDelegate().getLength();
        }

        public void jsSet_length(int length) {
            this.getDelegate().setLength(length);
        }

        public void put(int i, Scriptable scriptable, Object object) {
            if (object == null) {
                this.getDelegate().put(i, null);
            } else {
                if (!(object instanceof Option)) {
                    throw new IllegalArgumentException("May only add an Option to this array");
                }
                Option option = (Option)object;
                this.getDelegate().put(i, option.getDelegate());
            }
        }

        private SelectionOptions getDelegate() {
            return (SelectionOptions)((Object)this._scriptable);
        }
    }

    public static class Control
    extends JavaScriptEngine {
        private Form _form;

        public String getClassName() {
            return "Control";
        }

        public Form jsGet_form() {
            return this._form;
        }

        public void jsFunction_focus() {
        }

        public void jsFunction_select() {
        }

        public void jsFunction_click() throws IOException, SAXException {
            this.getDelegate().click();
        }

        private Input getDelegate() {
            return (Input)((Object)this._scriptable);
        }

        void initialize(JavaScriptEngine parent, ScriptableDelegate scriptable) throws JavaScriptException, NotAFunctionException, PropertyException, SAXException {
            super.initialize(parent, scriptable);
            this._form = (Form)parent;
        }
    }

    public static class Form
    extends HTMLElement {
        private ElementArray _controls;

        public String getClassName() {
            return "Form";
        }

        public String jsGet_action() {
            return this.getDelegate().getAction();
        }

        public void jsSet_action(String action) {
            this.getDelegate().setAction(action);
        }

        public Scriptable jsGet_elements() throws PropertyException, NotAFunctionException, JavaScriptException {
            if (this._controls == null) {
                this.initializeControls();
            }
            return this._controls;
        }

        public Object jsFunction_getElementsByTagName(String name) throws SAXException {
            return this.toElementArray(this.getDelegate().getElementsByTagName(name));
        }

        public void jsFunction_submit() throws IOException, SAXException {
            this.getDelegate().submit();
        }

        public void jsFunction_reset() throws IOException, SAXException {
            this.getDelegate().reset();
        }

        private void initializeControls() throws PropertyException, NotAFunctionException, JavaScriptException {
            ScriptableDelegate[] scriptables = this.getDelegate().getElementDelegates();
            JavaScriptEngine[] controls = new Control[scriptables.length];
            for (int i = 0; i < controls.length; ++i) {
                controls[i] = (Control)this.toScriptable(scriptables[i]);
            }
            this._controls = (ElementArray)Context.getCurrentContext().newObject((Scriptable)this, "ElementArray");
            this._controls.initialize(controls);
        }

        private WebForm.Scriptable getDelegate() {
            return (WebForm.Scriptable)this._scriptable;
        }
    }

    public static class Link
    extends HTMLElement {
        public Document jsGet_document() {
            return super.jsGet_document();
        }

        public String getClassName() {
            return "Link";
        }
    }

    public static class Image
    extends HTMLElement {
        public String getClassName() {
            return "Image";
        }
    }

    public static class HTMLElement
    extends JavaScriptEngine {
        private Document _document;

        public String getClassName() {
            return "HTMLElement";
        }

        public Document jsGet_document() {
            return this._document;
        }

        void initialize(JavaScriptEngine parent, ScriptableDelegate scriptable) throws JavaScriptException, NotAFunctionException, PropertyException, SAXException {
            super.initialize(parent, scriptable);
            this._document = (Document)parent;
        }
    }

    public static class ElementArray
    extends ScriptableObject {
        private JavaScriptEngine[] _contents = new HTMLElement[0];

        static ElementArray newElementArray(Scriptable parent) {
            try {
                return (ElementArray)Context.getCurrentContext().newObject(parent, "ElementArray");
            }
            catch (PropertyException e) {
                throw new RhinoException((Exception)((Object)e));
            }
            catch (NotAFunctionException e) {
                throw new RhinoException((Exception)((Object)e));
            }
            catch (JavaScriptException e) {
                throw new RhinoException((Exception)((Object)e));
            }
        }

        void initialize(JavaScriptEngine[] contents) {
            this._contents = contents;
        }

        public int jsGet_length() {
            return this._contents.length;
        }

        public String getClassName() {
            return "ElementArray";
        }

        public Object get(int i, Scriptable scriptable) {
            if (i >= 0 && i < this._contents.length) {
                return this._contents[i];
            }
            return super.get(i, scriptable);
        }

        public Object get(String name, Scriptable scriptable) {
            JavaScriptEngine content;
            int i;
            for (i = 0; i < this._contents.length; ++i) {
                content = this._contents[i];
                if (!name.equalsIgnoreCase(content.getID())) continue;
                return content;
            }
            for (i = 0; i < this._contents.length; ++i) {
                content = this._contents[i];
                if (!name.equalsIgnoreCase(content.getName())) continue;
                return content;
            }
            return super.get(name, scriptable);
        }

        protected JavaScriptEngine[] getContents() {
            return this._contents;
        }
    }

    public static class Screen
    extends JavaScriptEngine {
        private ClientProperties _clientProperties;

        void setClientProperties(ClientProperties clientProperties) {
            this._clientProperties = clientProperties;
        }

        public String getClassName() {
            return "Screen";
        }

        public int jsGet_availWidth() {
            return this._clientProperties.getAvailableScreenWidth();
        }

        public int jsGet_availHeight() {
            return this._clientProperties.getAvailHeight();
        }
    }

    public static class Navigator
    extends JavaScriptEngine {
        private ClientProperties _clientProperties;

        public String getClassName() {
            return "Navigator";
        }

        void setClientProperties(ClientProperties clientProperties) {
            this._clientProperties = clientProperties;
        }

        public String jsGet_appName() {
            return this._clientProperties.getApplicationName();
        }

        public String jsGet_appCodeName() {
            return this._clientProperties.getApplicationCodeName();
        }

        public String jsGet_appVersion() {
            return this._clientProperties.getApplicationVersion();
        }

        public String jsGet_userAgent() {
            return this._clientProperties.getUserAgent();
        }

        public String jsGet_platform() {
            return this._clientProperties.getPlatform();
        }

        public Object[] jsGet_plugins() {
            return new Object[0];
        }

        public boolean jsFunction_javaEnabled() {
            return false;
        }
    }

    public static class Location
    extends JavaScriptEngine {
        private URL _url;
        private Window _window;

        public String getClassName() {
            return "Location";
        }

        void initialize(Window window, URL url) {
            this._window = window;
            this._url = url;
        }

        public void jsFunction_replace(String urlString) throws IOException, SAXException {
            this._window.setLocation(urlString);
        }

        public String jsGet_href() {
            return this.toString();
        }

        public void jsSet_href(String urlString) throws SAXException, IOException {
            this._window.setLocation(urlString);
        }

        public String jsGet_protocol() {
            return this._url.getProtocol() + ':';
        }

        public String jsGet_host() {
            return this._url.getHost() + ':' + this._url.getPort();
        }

        public String jsGet_hostname() {
            return this._url.getHost();
        }

        public String jsGet_port() {
            return String.valueOf(this._url.getPort());
        }

        public String jsGet_pathname() {
            return this._url.getPath();
        }

        public void jsSet_pathname(String newPath) throws SAXException, IOException {
            if (!newPath.startsWith("/")) {
                newPath = '/' + newPath;
            }
            URL newURL = new URL(this._url, newPath);
            this._window.setLocation(newURL.toExternalForm());
        }

        public String jsGet_search() {
            return '?' + this._url.getQuery();
        }

        public void jsSet_search(String newSearch) throws SAXException, IOException {
            if (!newSearch.startsWith("?")) {
                newSearch = '?' + newSearch;
            }
            this._window.setLocation(this.jsGet_protocol() + "//" + this.jsGet_host() + this.jsGet_pathname() + newSearch);
        }

        public Object getDefaultValue(Class typeHint) {
            return this._url.toExternalForm();
        }

        public String toString() {
            return this._url.toExternalForm();
        }
    }

    public static class Document
    extends JavaScriptEngine {
        private ElementArray _forms;
        private ElementArray _links;
        private ElementArray _images;
        private StringBuffer _writeBuffer;
        private String _mimeType;

        public String getClassName() {
            return "Document";
        }

        public String jsGet_title() throws SAXException {
            return this.getDelegate().getTitle();
        }

        public Scriptable jsGet_images() throws SAXException {
            if (this._images == null) {
                this._images = this.toElementArray(this.getDelegate().getImages());
            }
            return this._images;
        }

        public Scriptable jsGet_links() throws SAXException {
            if (this._links == null) {
                this._links = this.toElementArray(this.getDelegate().getLinks());
            }
            return this._links;
        }

        public Scriptable jsGet_forms() throws SAXException {
            if (this._forms == null) {
                this._forms = this.toElementArray(this.getDelegate().getForms());
            }
            return this._forms;
        }

        public Object jsFunction_getElementById(String id) {
            return this.toScriptable(this.getDelegate().getElementWithID(id));
        }

        public Object jsFunction_getElementsByName(String name) {
            return this.toElementArray(this.getDelegate().getElementsByName(name));
        }

        public Object jsFunction_getElementsByTagName(String name) {
            return this.toElementArray(this.getDelegate().getElementsByTagName(name));
        }

        public Object jsGet_location() {
            return this._parent == null ? NOT_FOUND : this.getWindow().jsGet_location();
        }

        public void jsSet_location(String urlString) throws IOException, SAXException {
            if (urlString.startsWith("color")) {
                return;
            }
            this.getWindow().setLocation(urlString);
        }

        public String jsGet_cookie() {
            return this.getDelegate().getCookie();
        }

        public void jsSet_cookie(String cookieSpec) {
            int equalsIndex = cookieSpec.indexOf(61);
            int endIndex = cookieSpec.indexOf(";", equalsIndex);
            if (endIndex < 0) {
                endIndex = cookieSpec.length();
            }
            String name = cookieSpec.substring(0, equalsIndex);
            String value = cookieSpec.substring(equalsIndex + 1, endIndex);
            this.getDelegate().setCookie(name, value);
        }

        private Window getWindow() {
            return (Window)this._parent;
        }

        public void jsFunction_open(Object mimeType) {
            this._mimeType = Document.toStringIfNotUndefined(mimeType);
        }

        public void jsFunction_close() {
            if (this.getDelegate().replaceText(this.getWriteBuffer().toString(), this._mimeType == null ? "text/html" : this._mimeType)) {
                this.getWriteBuffer().setLength(0);
            }
        }

        public void jsFunction_write(String string) {
            this.getWriteBuffer().append(string);
        }

        public void jsFunction_writeln(String string) {
            this.getWriteBuffer().append(string).append('\r').append('\n');
        }

        protected StringBuffer getWriteBuffer() {
            if (this._writeBuffer == null) {
                this._writeBuffer = new StringBuffer();
            }
            return this._writeBuffer;
        }

        protected void clearWriteBuffer() {
            this._writeBuffer = null;
        }

        private HTMLPage.Scriptable getDelegate() {
            return (HTMLPage.Scriptable)this._scriptable;
        }
    }

    public static class Window
    extends JavaScriptEngine {
        private Document _document;
        private Navigator _navigator;
        private Location _location;
        private Screen _screen;
        private ElementArray _frames;

        public String getClassName() {
            return "Window";
        }

        public Window jsGet_window() {
            return this;
        }

        public Window jsGet_self() {
            return this;
        }

        public Document jsGet_document() {
            if (this._document == null) {
                this._document = (Document)this.toScriptable(this.getDelegate().getDocument());
            }
            return this._document;
        }

        public Scriptable jsGet_frames() throws SAXException, PropertyException, JavaScriptException, NotAFunctionException {
            if (this._frames == null) {
                WebResponse.Scriptable[] scriptables = this.getDelegate().getFrames();
                JavaScriptEngine[] frames = new Window[scriptables.length];
                for (int i = 0; i < frames.length; ++i) {
                    frames[i] = (Window)this.toScriptable(scriptables[i]);
                }
                this._frames = (ElementArray)Context.getCurrentContext().newObject((Scriptable)this, "ElementArray");
                this._frames.initialize(frames);
            }
            return this._frames;
        }

        public Navigator jsGet_navigator() {
            return this._navigator;
        }

        public Screen jsGet_screen() {
            return this._screen;
        }

        public Location jsGet_location() {
            return this._location;
        }

        public void jsSet_location(String relativeURL) throws IOException, SAXException {
            this.setLocation(relativeURL);
        }

        void setLocation(String relativeURL) throws IOException, SAXException {
            this.getDelegate().setLocation(relativeURL);
        }

        void initialize(JavaScriptEngine parent, ScriptableDelegate scriptable) throws JavaScriptException, NotAFunctionException, PropertyException, SAXException {
            super.initialize(parent, scriptable);
            this._location = (Location)Context.getCurrentContext().newObject((Scriptable)this, "Location");
            this._location.initialize(this, ((WebResponse.Scriptable)scriptable).getURL());
            this._navigator = (Navigator)Context.getCurrentContext().newObject((Scriptable)this, "Navigator");
            this._navigator.setClientProperties(this.getDelegate().getClientProperties());
            this._screen = (Screen)Context.getCurrentContext().newObject((Scriptable)this, "Screen");
            this._screen.setClientProperties(this.getDelegate().getClientProperties());
            this.getDelegate().load();
        }

        public void jsFunction_alert(String message) {
            this.getDelegate().alert(message);
        }

        public boolean jsFunction_confirm(String message) {
            return this.getDelegate().getConfirmationResponse(message);
        }

        public String jsFunction_prompt(String message, String defaultResponse) {
            return this.getDelegate().getUserResponse(message, defaultResponse);
        }

        public void jsFunction_moveTo(int x, int y) {
        }

        public void jsFunction_focus() {
        }

        public void jsFunction_setTimeout() {
        }

        public void jsFunction_close() {
            this.getDelegate().close();
        }

        public Window jsFunction_open(Object url, String name, String features, boolean replace) throws PropertyException, JavaScriptException, NotAFunctionException, IOException, SAXException {
            return (Window)this.toScriptable(this.getDelegate().open(Window.toStringIfNotUndefined(url), name, features, replace));
        }

        protected StringBuffer getDocumentWriteBuffer() {
            return this.jsGet_document().getWriteBuffer();
        }

        protected void discardDocumentWriteBuffer() {
            this.jsGet_document().clearWriteBuffer();
        }

        private WebResponse.Scriptable getDelegate() {
            return (WebResponse.Scriptable)this._scriptable;
        }
    }

    static abstract class JavaScriptEngine
    extends ScriptableObject
    implements ScriptingEngine {
        protected ScriptableDelegate _scriptable;
        protected JavaScriptEngine _parent;

        JavaScriptEngine() {
        }

        public boolean supportsScriptLanguage(String language) {
            return language == null || language.toLowerCase().startsWith("javascript");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String executeScript(String language, String script) {
            if (!this.supportsScriptLanguage(language)) {
                return "";
            }
            try {
                script = script.trim();
                if (script.startsWith("<!--") && (script = this.withoutFirstLine(script)).endsWith("-->")) {
                    script = script.substring(0, script.lastIndexOf("-->"));
                }
                Context.getCurrentContext().evaluateString((Scriptable)this, script, "httpunit", 0, null);
                StringBuffer buffer = this.getDocumentWriteBuffer();
                String string = buffer.toString();
                return string;
            }
            catch (Exception e) {
                this.handleScriptException(e, "Script '" + script + "'");
                String string = "";
                return string;
            }
            finally {
                this.discardDocumentWriteBuffer();
            }
        }

        protected StringBuffer getDocumentWriteBuffer() {
            throw new IllegalStateException("may not run executeScript() from " + this.getClass());
        }

        protected void discardDocumentWriteBuffer() {
            throw new IllegalStateException("may not run executeScript() from " + this.getClass());
        }

        private String withoutFirstLine(String script) {
            for (int i = 0; i < script.length(); ++i) {
                if (!this.isLineTerminator(script.charAt(i))) continue;
                return script.substring(i).trim();
            }
            return "";
        }

        private boolean isLineTerminator(char c) {
            return c == '\n' || c == '\r';
        }

        public boolean performEvent(String eventScript) {
            try {
                Context context = Context.getCurrentContext();
                context.setOptimizationLevel(-1);
                Function f = context.compileFunction((Scriptable)this, "function x() { " + eventScript + "}", "httpunit", 0, null);
                Object result = f.call(context, (Scriptable)this, (Scriptable)this, NO_ARGS);
                return result instanceof Boolean ? (Boolean)result : true;
            }
            catch (Exception e) {
                this.handleScriptException(e, "Event '" + eventScript + "'");
                return false;
            }
        }

        public String getURLContents(String urlString) {
            try {
                Object result = Context.getCurrentContext().evaluateString((Scriptable)this, urlString, "httpunit", 0, null);
                return result == null || result instanceof Undefined ? null : result.toString();
            }
            catch (Exception e) {
                this.handleScriptException(e, "URL '" + urlString + "'");
                return null;
            }
        }

        private void handleScriptException(Exception e, String badScript) {
            String errorMessage = badScript + " failed: " + e;
            if (!(e instanceof EcmaError) && !(e instanceof EvaluatorException)) {
                e.printStackTrace();
                throw new RuntimeException(errorMessage);
            }
            if (JavaScript.isThrowExceptionsOnError()) {
                e.printStackTrace();
                throw new ScriptException(errorMessage);
            }
            _errorMessages.add(errorMessage);
        }

        void initialize(JavaScriptEngine parent, ScriptableDelegate scriptable) throws SAXException, PropertyException, JavaScriptException, NotAFunctionException {
            this._scriptable = scriptable;
            this._scriptable.setScriptEngine(this);
            this._parent = parent;
            if (parent != null) {
                this.setParentScope((Scriptable)parent);
            }
        }

        String getName() {
            return this._scriptable instanceof NamedDelegate ? ((NamedDelegate)((Object)this._scriptable)).getName() : "";
        }

        String getID() {
            return this._scriptable instanceof IdentifiedDelegate ? ((IdentifiedDelegate)((Object)this._scriptable)).getID() : "";
        }

        public boolean has(String propertyName, Scriptable scriptable) {
            return super.has(propertyName, scriptable) || this._scriptable != null && this._scriptable.get(propertyName) != null;
        }

        public Object get(String propertyName, Scriptable scriptable) {
            Object result = super.get(propertyName, scriptable);
            if (result != NOT_FOUND) {
                return result;
            }
            if (this._scriptable == null) {
                return NOT_FOUND;
            }
            return this.convertIfNeeded(this._scriptable.get(propertyName));
        }

        public Object get(int i, Scriptable scriptable) {
            Object result = super.get(i, scriptable);
            if (result != NOT_FOUND) {
                return result;
            }
            if (this._scriptable == null) {
                return NOT_FOUND;
            }
            return this.convertIfNeeded(this._scriptable.get(i));
        }

        private Object convertIfNeeded(Object property) {
            if (property == null) {
                return NOT_FOUND;
            }
            if (property instanceof ScriptableDelegate[]) {
                return this.toScriptable((ScriptableDelegate[])property);
            }
            if (!(property instanceof ScriptableDelegate)) {
                return property;
            }
            return this.toScriptable((ScriptableDelegate)property);
        }

        private Object toScriptable(ScriptableDelegate[] list) {
            Object[] delegates = new Object[list.length];
            for (int i = 0; i < delegates.length; ++i) {
                delegates[i] = this.toScriptable(list[i]);
            }
            return Context.getCurrentContext().newArray((Scriptable)this, delegates);
        }

        public void put(String propertyName, Scriptable scriptable, Object value) {
            if (this._scriptable == null || this._scriptable.get(propertyName) == null) {
                super.put(propertyName, scriptable, value);
            } else {
                this._scriptable.set(propertyName, value);
            }
        }

        public String toString() {
            return (this._scriptable == null ? "prototype " : "") + this.getClassName();
        }

        public ScriptingEngine newScriptingEngine(ScriptableDelegate child) {
            try {
                return (ScriptingEngine)this.toScriptable(child);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.toString());
            }
        }

        protected static String toStringIfNotUndefined(Object object) {
            return object == null || Undefined.instance.equals(object) ? null : object.toString();
        }

        final Object toScriptable(ScriptableDelegate delegate) {
            if (delegate == null) {
                return NOT_FOUND;
            }
            if (delegate.getScriptEngine() instanceof Scriptable) {
                return (Scriptable)delegate.getScriptEngine();
            }
            try {
                JavaScriptEngine element = (JavaScriptEngine)Context.getCurrentContext().newObject((Scriptable)this, this.getScriptableClassName(delegate));
                element.initialize(this, delegate);
                return element;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RhinoException(e);
            }
        }

        private String getScriptableClassName(ScriptableDelegate delegate) {
            if (delegate instanceof WebResponse.Scriptable) {
                return "Window";
            }
            if (delegate instanceof HTMLPage.Scriptable) {
                return "Document";
            }
            if (delegate instanceof WebForm.Scriptable) {
                return "Form";
            }
            if (delegate instanceof WebLink.Scriptable) {
                return "Link";
            }
            if (delegate instanceof WebImage.Scriptable) {
                return "Image";
            }
            if (delegate instanceof SelectionOptions) {
                return "Options";
            }
            if (delegate instanceof SelectionOption) {
                return "Option";
            }
            if (delegate instanceof Input) {
                return "Control";
            }
            if (delegate instanceof DocumentElement) {
                return "HTMLElement";
            }
            throw new IllegalArgumentException("Unknown ScriptableDelegate class: " + delegate.getClass());
        }

        protected ElementArray toElementArray(ScriptableDelegate[] scriptables) {
            JavaScriptEngine[] elements = new JavaScriptEngine[scriptables.length];
            for (int i = 0; i < elements.length; ++i) {
                elements[i] = (JavaScriptEngine)this.toScriptable(scriptables[i]);
            }
            ElementArray result = ElementArray.newElementArray((Scriptable)this);
            result.initialize(elements);
            return result;
        }
    }
}

