/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2;

import com.sun.xml.bind.api.TypeReference;
import com.sun.xml.bind.v2.Messages;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.util.FinalArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextFactory {
    public static JAXBContext createContext(Class[] classes, Map<String, Object> properties) throws JAXBException {
        properties = properties == null ? Collections.emptyMap() : new HashMap<String, Object>(properties);
        String defaultNsUri = ContextFactory.getPropertyValue(properties, "com.sun.xml.bind.defaultNamespaceRemap", String.class);
        Boolean c14nSupport = ContextFactory.getPropertyValue(properties, "com.sun.xml.bind.c14n", Boolean.class);
        if (c14nSupport == null) {
            c14nSupport = false;
        }
        if (!properties.isEmpty()) {
            throw new JAXBException(Messages.UNSUPPORTED_PROPERTY.format(properties.keySet().iterator().next()));
        }
        return ContextFactory.createContext(classes, Collections.<TypeReference>emptyList(), defaultNsUri, c14nSupport);
    }

    private static <T> T getPropertyValue(Map<String, Object> properties, String keyName, Class<T> type) throws JAXBException {
        Object o = properties.get(keyName);
        if (o == null) {
            return null;
        }
        properties.remove(keyName);
        if (!type.isInstance(o)) {
            throw new JAXBException(Messages.INVALID_PROPERTY_VALUE.format(keyName, o));
        }
        return type.cast(o);
    }

    public static JAXBContext createContext(Class[] classes, Collection<TypeReference> typeRefs, String defaultNsUri, boolean c14nSupport) throws JAXBException {
        return new JAXBContextImpl(classes, typeRefs, defaultNsUri, c14nSupport);
    }

    public static JAXBContext createContext(String contextPath, ClassLoader classLoader, Map<String, Object> properties) throws JAXBException {
        FinalArrayList<Class> classes = new FinalArrayList<Class>();
        StringTokenizer tokens = new StringTokenizer(contextPath, ":");
        while (tokens.hasMoreTokens()) {
            List<Class> indexedClasses;
            boolean foundJaxbIndex = false;
            boolean foundObjectFactory = false;
            String pkg = tokens.nextToken();
            try {
                Class<?> o = classLoader.loadClass(pkg + ".ObjectFactory");
                classes.add(o);
                foundObjectFactory = true;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                indexedClasses = ContextFactory.loadIndexedClasses(pkg, classLoader);
            }
            catch (IOException e) {
                throw new JAXBException((Throwable)e);
            }
            if (indexedClasses != null) {
                classes.addAll(indexedClasses);
                foundJaxbIndex = true;
            }
            if (foundObjectFactory || foundJaxbIndex) continue;
            throw new JAXBException(Messages.BROKEN_CONTEXTPATH.format(pkg));
        }
        return ContextFactory.createContext(classes.toArray(new Class[classes.size()]), properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Class> loadIndexedClasses(String pkg, ClassLoader classLoader) throws IOException, JAXBException {
        String resource = pkg.replace('.', '/') + "/jaxb.index";
        InputStream resourceAsStream = classLoader.getResourceAsStream(resource);
        if (resourceAsStream == null) {
            return null;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(resourceAsStream, "UTF-8"));
        try {
            FinalArrayList<Class> classes = new FinalArrayList<Class>();
            String className = in.readLine();
            while (className != null) {
                if ((className = className.trim()).startsWith("#") || className.length() == 0) {
                    className = in.readLine();
                    continue;
                }
                if (className.endsWith(".class")) {
                    throw new JAXBException(Messages.ILLEGAL_ENTRY.format(className));
                }
                try {
                    classes.add(classLoader.loadClass(pkg + '.' + className));
                }
                catch (ClassNotFoundException e) {
                    throw new JAXBException(Messages.ERROR_LOADING_CLASS.format(className, resource));
                }
                className = in.readLine();
            }
            FinalArrayList<Class> finalArrayList = classes;
            return finalArrayList;
        }
        finally {
            in.close();
        }
    }
}

