/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.discovery;

import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import net.jqwik.engine.descriptor.ContainerClassDescriptor;
import net.jqwik.engine.descriptor.SkipExecutionDecorator;
import net.jqwik.engine.discovery.ElementResolver;
import net.jqwik.engine.discovery.specs.DiscoverySpec;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;

public abstract class AbstractClassResolver
implements ElementResolver {
    @Override
    public Set<TestDescriptor> resolveElement(AnnotatedElement element, TestDescriptor parent) {
        if (!(element instanceof Class)) {
            return Collections.emptySet();
        }
        Class clazz = (Class)element;
        if (!this.shouldBeResolved(clazz)) {
            return Collections.emptySet();
        }
        UniqueId uniqueId = this.createUniqueId(clazz, parent);
        return Collections.singleton(this.resolveClass(clazz, uniqueId));
    }

    @Override
    public Optional<TestDescriptor> resolveUniqueId(UniqueId.Segment segment, TestDescriptor parent) {
        if (!segment.getType().equals("class")) {
            return Optional.empty();
        }
        if (!this.requiredParentType().isInstance(parent)) {
            return Optional.empty();
        }
        String className = segment.getValue();
        Optional optionalContainerClass = ReflectionSupport.tryToLoadClass((String)className).toOptional();
        if (!optionalContainerClass.isPresent()) {
            return Optional.empty();
        }
        Class containerClass = (Class)optionalContainerClass.get();
        if (!this.shouldBeResolved(containerClass)) {
            return Optional.empty();
        }
        UniqueId uniqueId = this.createUniqueId(containerClass, parent);
        return Optional.of(this.resolveClass(containerClass, uniqueId));
    }

    private boolean shouldBeResolved(Class<?> element) {
        return this.getDiscoverySpec().shouldBeDiscovered(element);
    }

    private TestDescriptor resolveClass(Class<?> testClass, UniqueId uniqueId) {
        ContainerClassDescriptor newContainerDescriptor = this.createContainerDescriptor(testClass, uniqueId);
        Node.SkipResult shouldBeSkipped = this.getDiscoverySpec().shouldBeSkipped(testClass);
        if (shouldBeSkipped.isSkipped()) {
            return new SkipExecutionDecorator(newContainerDescriptor, shouldBeSkipped.getReason().orElse(""));
        }
        return newContainerDescriptor;
    }

    protected abstract Class<? extends TestDescriptor> requiredParentType();

    protected abstract DiscoverySpec<Class<?>> getDiscoverySpec();

    protected abstract UniqueId createUniqueId(Class<?> var1, TestDescriptor var2);

    protected abstract ContainerClassDescriptor createContainerDescriptor(Class<?> var1, UniqueId var2);
}

