/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.hooks.statistics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.jqwik.api.Tuple;
import net.jqwik.api.statistics.StatisticsCollector;
import net.jqwik.api.statistics.StatisticsCoverage;
import net.jqwik.api.statistics.StatisticsEntry;
import net.jqwik.engine.hooks.statistics.StatisticsEntryImpl;
import org.opentest4j.AssertionFailedError;

public class StatisticsCollectorImpl
implements StatisticsCollector {
    public static final Object COLLECTORS_ID = Tuple.of(StatisticsCollectorImpl.class, (Object)"collectors");
    private final Map<List<Object>, Integer> counts = new LinkedHashMap<List<Object>, Integer>();
    private final List<Consumer<StatisticsCoverage>> coverageCheckers = new ArrayList<Consumer<StatisticsCoverage>>();
    private final String label;
    private List<StatisticsEntryImpl> statisticsEntries = null;

    public StatisticsCollectorImpl(String label) {
        this.label = label;
    }

    public StatisticsCollector collect(Object ... values) {
        this.ensureAtLeastOneParameter(values);
        List<Object> key = this.keyFrom(values);
        this.ensureSameNumberOfValues(key);
        this.updateCounts(key);
        return this;
    }

    private void updateCounts(List<Object> key) {
        int count = this.counts.computeIfAbsent(key, any -> 0);
        this.counts.put(key, ++count);
        this.statisticsEntries = null;
    }

    private void ensureAtLeastOneParameter(Object[] values) {
        if (Arrays.equals(values, new Object[0])) {
            String message = String.format("StatisticsCollector[%s] must be called with at least one value", this.label);
            throw new IllegalArgumentException(message);
        }
    }

    private void ensureSameNumberOfValues(List<Object> keyCandidate) {
        if (this.counts.isEmpty()) {
            return;
        }
        List<Object> anyKey = this.counts.keySet().iterator().next();
        if (anyKey.size() != keyCandidate.size()) {
            String message = String.format("StatisticsCollector[%s] must always be called with same number of values", this.label);
            throw new IllegalArgumentException(message);
        }
    }

    private List<Object> keyFrom(Object[] values) {
        if (values != null) {
            return Arrays.asList(values);
        }
        return Collections.singletonList(null);
    }

    public double percentage(Object ... values) {
        return this.statisticsEntry(values).percentage();
    }

    private StatisticsEntry statisticsEntry(Object[] values) {
        List<Object> key = this.keyFrom(values);
        return this.statisticsEntries().stream().filter(entry -> entry.values().equals(key)).findFirst().orElse(StatisticsEntryImpl.nullFor(key));
    }

    private StatisticsEntry query(Predicate<? super List<?>> query, int countAll) {
        return this.statisticsEntries().stream().filter(entry -> {
            List<Object> values = entry.values();
            return query.test(values);
        }).reduce(StatisticsEntryImpl.nullWithName("<adhoc query>"), (statisticsEntry, other) -> statisticsEntry.plus((StatisticsEntryImpl)other, countAll));
    }

    private StatisticsEntryImpl matchPattern(String regex, int countAll) {
        String name = String.format("<pattern: %s>", regex);
        return this.statisticsEntries().stream().filter(entry -> {
            if (entry.values().size() != 1) {
                return false;
            }
            Object value = entry.values().get(0);
            if (!(value instanceof CharSequence)) {
                return false;
            }
            CharSequence toMatch = (CharSequence)value;
            return Pattern.matches(regex, toMatch);
        }).reduce(StatisticsEntryImpl.nullWithName(name), (statisticsEntry, other) -> statisticsEntry.plus((StatisticsEntryImpl)other, countAll));
    }

    public int countAllCollects() {
        return this.counts.values().stream().mapToInt(aCount -> aCount).sum();
    }

    public int count(Object ... values) {
        return this.statisticsEntry(values).count();
    }

    public void coverage(Consumer<StatisticsCoverage> checker) {
        if (!this.coverageCheckers.contains(checker)) {
            this.coverageCheckers.add(checker);
        }
    }

    public void checkCoverage() {
        for (Consumer<StatisticsCoverage> checker : this.coverageCheckers) {
            StatisticsCoverageImpl coverage = new StatisticsCoverageImpl();
            checker.accept(coverage);
        }
    }

    public Map<List<Object>, Integer> getCounts() {
        return this.counts;
    }

    public List<StatisticsEntryImpl> statisticsEntries() {
        if (this.statisticsEntries != null) {
            return this.statisticsEntries;
        }
        this.statisticsEntries = this.calculateStatistics();
        return this.statisticsEntries;
    }

    private List<StatisticsEntryImpl> calculateStatistics() {
        int sum = this.countAllCollects();
        return this.counts.entrySet().stream().sorted(this::compareStatisticsEntries).filter(entry -> !((List)entry.getKey()).equals(Collections.emptyList())).map(entry -> {
            double percentage = (double)((Integer)entry.getValue()).intValue() * 100.0 / (double)sum;
            return new StatisticsEntryImpl((List)entry.getKey(), this.displayKey((List)entry.getKey()), (Integer)entry.getValue(), percentage);
        }).collect(Collectors.toList());
    }

    private int compareStatisticsEntries(Map.Entry<List<Object>, Integer> e1, Map.Entry<List<Object>, Integer> e2) {
        List<Object> k1 = e1.getKey();
        List<Object> k2 = e2.getKey();
        if (k1.size() != k2.size()) {
            return Integer.compare(k1.size(), k2.size());
        }
        return e2.getValue().compareTo(e1.getValue());
    }

    private String displayKey(List<Object> key) {
        return key.stream().map(Objects::toString).collect(Collectors.joining(" "));
    }

    String label() {
        return this.label;
    }

    private static String statisticsLabel(String label) {
        return label.equals("statistics") ? "" : String.format(" for label \"%s\"", label);
    }

    private class StatisticsCoverageImpl
    implements StatisticsCoverage {
        private StatisticsCoverageImpl() {
        }

        public StatisticsCoverage.CoverageChecker check(Object ... values) {
            StatisticsEntry entry = StatisticsCollectorImpl.this.statisticsEntry(values);
            return new CoverageCheckerImpl(StatisticsCollectorImpl.this.label, entry, StatisticsCollectorImpl.this.countAllCollects());
        }

        public StatisticsCoverage.CoverageChecker checkQuery(Predicate<? super List<?>> query) {
            int countAll = StatisticsCollectorImpl.this.countAllCollects();
            StatisticsEntry entry = StatisticsCollectorImpl.this.query(query, countAll);
            return new CoverageCheckerImpl(StatisticsCollectorImpl.this.label, entry, countAll);
        }

        public StatisticsCoverage.CoverageChecker checkPattern(String regex) {
            int countAll = StatisticsCollectorImpl.this.countAllCollects();
            StatisticsEntryImpl entry = StatisticsCollectorImpl.this.matchPattern(regex, countAll);
            return new CoverageCheckerImpl(StatisticsCollectorImpl.this.label, entry, countAll);
        }
    }

    private static class CoverageCheckerImpl
    implements StatisticsCoverage.CoverageChecker {
        private final String label;
        private final StatisticsEntry entry;
        private final int countAll;

        public CoverageCheckerImpl(String label, StatisticsEntry entry, int countAll) {
            this.label = label;
            this.entry = entry;
            this.countAll = countAll;
        }

        public void count(Predicate<? super Integer> countChecker) {
            if (!countChecker.test((Integer)this.entry.count())) {
                String condition = String.format("Count of %s", this.entry.count());
                this.failCondition(condition);
            }
        }

        public void count(BiPredicate<? super Integer, ? super Integer> countChecker) {
            if (!countChecker.test((Integer)this.entry.count(), (Integer)this.countAll)) {
                String condition = String.format("Count of (%s, %s)", this.entry.count(), this.countAll);
                this.failCondition(condition);
            }
        }

        public void count(Consumer<? super Integer> countChecker) {
            this.count((? super Integer c) -> {
                countChecker.accept((Integer)c);
                return true;
            });
        }

        public void count(BiConsumer<? super Integer, ? super Integer> countChecker) {
            this.count((? super Integer c, ? super Integer a) -> {
                countChecker.accept((Integer)c, (Integer)a);
                return true;
            });
        }

        public void percentage(Predicate<? super Double> percentageChecker) {
            if (!percentageChecker.test((Double)this.entry.percentage())) {
                String condition = String.format("Percentage of %s", this.entry.percentage());
                this.failCondition(condition);
            }
        }

        public void percentage(Consumer<? super Double> percentageChecker) {
            this.percentage((? super Double p) -> {
                percentageChecker.accept((Double)p);
                return true;
            });
        }

        private void failCondition(String condition) {
            String message = String.format("%s for %s does not fulfill condition%s", condition, this.entry.name(), StatisticsCollectorImpl.statisticsLabel(this.label));
            this.fail(message);
        }

        private void fail(String message) {
            throw new AssertionFailedError(message);
        }
    }
}

