/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.FeatureExtractor;

public class UniquenessChecker {
    public static <T> boolean checkShrinkableUniqueIn(Collection<? extends FeatureExtractor<T>> extractors, Shrinkable<T> shrinkable, List<? extends Shrinkable<T>> shrinkables) {
        if (extractors.isEmpty()) {
            return true;
        }
        Object value = shrinkable.value();
        List elements = shrinkables.stream().map(Shrinkable::value).collect(Collectors.toList());
        return UniquenessChecker.checkValueUniqueIn(extractors, value, elements);
    }

    public static <T> boolean checkValueUniqueIn(Collection<? extends FeatureExtractor<T>> extractors, T value, Collection<? extends T> elements) {
        for (FeatureExtractor<? extends T> featureExtractor : extractors) {
            if (featureExtractor.isUniqueIn((T)value, elements)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean checkUniquenessOfShrinkables(Collection<? extends FeatureExtractor<T>> extractors, List<? extends Shrinkable<T>> shrinkables) {
        if (extractors.isEmpty()) {
            return true;
        }
        List elements = shrinkables.stream().map(Shrinkable::value).collect(Collectors.toList());
        return UniquenessChecker.checkUniquenessOfValues(extractors, elements);
    }

    public static <T> boolean checkUniquenessOfValues(Collection<? extends FeatureExtractor<T>> extractors, Collection<? extends T> elements) {
        for (FeatureExtractor<? extends T> featureExtractor : extractors) {
            if (featureExtractor.areUnique(elements)) continue;
            return false;
        }
        return true;
    }
}

