/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.Tuple;
import net.jqwik.api.arbitraries.FunctionArbitrary;
import net.jqwik.api.support.HashCodeSupport;
import net.jqwik.api.support.LambdaSupport;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.TypedCloneable;
import net.jqwik.engine.properties.arbitraries.randomized.ConstantFunctionGenerator;
import net.jqwik.engine.properties.arbitraries.randomized.FunctionGenerator;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;

public class DefaultFunctionArbitrary<F, R>
extends TypedCloneable
implements FunctionArbitrary<F, R> {
    private final Class<F> functionalType;
    private final Arbitrary<R> resultArbitrary;
    private final List<Tuple.Tuple2<Predicate<? super List<?>>, Function<? super List<?>, ? extends R>>> conditions = new ArrayList();

    public DefaultFunctionArbitrary(Class<F> functionalType, Arbitrary<R> resultArbitrary) {
        this.functionalType = functionalType;
        this.resultArbitrary = resultArbitrary;
    }

    public RandomGenerator<F> generator(int genSize) {
        return RandomGenerators.oneOf(this.createGenerators(genSize, false));
    }

    public RandomGenerator<F> generatorWithEmbeddedEdgeCases(int genSize) {
        return RandomGenerators.oneOf(this.createGenerators(genSize, true));
    }

    public EdgeCases<F> edgeCases(int maxEdgeCases) {
        ConstantFunctionGenerator constantFunctionGenerator = this.createConstantFunctionGenerator(1000, true);
        return EdgeCasesSupport.mapShrinkable(this.resultArbitrary.edgeCases(maxEdgeCases), x$0 -> constantFunctionGenerator.createConstantFunction((Shrinkable)x$0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultFunctionArbitrary that = (DefaultFunctionArbitrary)o;
        if (!this.functionalType.equals(that.functionalType)) {
            return false;
        }
        if (!this.resultArbitrary.equals(that.resultArbitrary)) {
            return false;
        }
        return this.conditionsAreEqual(this.conditions, that.conditions);
    }

    private boolean conditionsAreEqual(List<Tuple.Tuple2<Predicate<? super List<?>>, Function<? super List<?>, ? extends R>>> left, List<Tuple.Tuple2<Predicate<? super List<?>>, Function<? super List<?>, ? extends R>>> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (int i = 0; i < left.size(); ++i) {
            Tuple.Tuple2<Predicate<? super List<?>>, Function<? super List<?>, ? extends R>> leftCondition = left.get(i);
            Tuple.Tuple2<Predicate<? super List<?>>, Function<? super List<?>, ? extends R>> rightCondition = right.get(i);
            if (!LambdaSupport.areEqual((Object)((Predicate)leftCondition.get1()), (Object)((Predicate)rightCondition.get1()))) {
                return false;
            }
            if (LambdaSupport.areEqual((Object)((Function)leftCondition.get2()), (Object)((Function)rightCondition.get2()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return HashCodeSupport.hash(this.functionalType, this.resultArbitrary);
    }

    private List<RandomGenerator<F>> createGenerators(int genSize, boolean withEmbeddedEdgeCases) {
        ConstantFunctionGenerator<F, R> constantFunctionGenerator = this.createConstantFunctionGenerator(genSize, withEmbeddedEdgeCases);
        FunctionGenerator<F, ? extends R> functionGenerator = new FunctionGenerator<F, R>(this.functionalType, this.resultArbitrary.generator(genSize, withEmbeddedEdgeCases), this.conditions);
        return Arrays.asList(constantFunctionGenerator, functionGenerator, functionGenerator, functionGenerator, functionGenerator);
    }

    private ConstantFunctionGenerator<F, R> createConstantFunctionGenerator(int genSize, boolean withEmbeddedEdgeCases) {
        return new ConstantFunctionGenerator<F, R>(this.functionalType, this.resultArbitrary.generator(genSize, withEmbeddedEdgeCases), this.conditions);
    }

    public <F_ extends F> FunctionArbitrary<F_, R> when(Predicate<? super List<?>> parameterCondition, Function<? super List<?>, ? extends R> answer) {
        DefaultFunctionArbitrary clone = (DefaultFunctionArbitrary)this.typedClone();
        clone.conditions.addAll(this.conditions);
        clone.addCondition(Tuple.of(parameterCondition, answer));
        return clone;
    }

    private void addCondition(Tuple.Tuple2<Predicate<? super List<?>>, Function<? super List<?>, ? extends R>> condition) {
        this.conditions.add(condition);
    }
}

